<?php
/**
 * Copyright (c) 2015-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to
 * use, copy, modify, and distribute this software in source code or binary
 * form for use in connection with the web services and APIs provided by
 * Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use
 * of this software is subject to the Facebook Developer Principles and
 * Policies [http://developers.facebook.com/policy/]. This copyright notice
 * shall be included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

namespace FacebookAds\Object\Fields;

use FacebookAds\Enum\AbstractEnum;

/**
 * This class is auto-generated.
 *
 * For any issues or feature requests related to this class, please let us know
 * on github and we'll fix in our codegen framework. We'll not be able to accept
 * pull request for this class.
 *
 */

class AdsInsightsFields extends AbstractEnum {

  const ACCOUNT_CURRENCY = 'account_currency';
  const ACCOUNT_ID = 'account_id';
  const ACCOUNT_NAME = 'account_name';
  const ACTION_VALUES = 'action_values';
  const ACTIONS = 'actions';
  const ACTIONS_PER_IMPRESSION = 'actions_per_impression';
  const ACTIONS_RESULTS = 'actions_results';
  const ACTIVITY_RECENCY = 'activity_recency';
  const AD_BID_TYPE = 'ad_bid_type';
  const AD_BID_VALUE = 'ad_bid_value';
  const AD_CLICK_ACTIONS = 'ad_click_actions';
  const AD_DELIVERY = 'ad_delivery';
  const AD_FORMAT_ASSET = 'ad_format_asset';
  const AD_ID = 'ad_id';
  const AD_IMPRESSION_ACTIONS = 'ad_impression_actions';
  const AD_NAME = 'ad_name';
  const ADSET_BID_TYPE = 'adset_bid_type';
  const ADSET_BID_VALUE = 'adset_bid_value';
  const ADSET_BUDGET_TYPE = 'adset_budget_type';
  const ADSET_BUDGET_VALUE = 'adset_budget_value';
  const ADSET_DELIVERY = 'adset_delivery';
  const ADSET_END = 'adset_end';
  const ADSET_ID = 'adset_id';
  const ADSET_NAME = 'adset_name';
  const ADSET_START = 'adset_start';
  const AGE = 'age';
  const AGE_TARGETING = 'age_targeting';
  const AMOUNT_IN_CATALOG_CURRENCY = 'amount_in_catalog_currency';
  const APP_STORE_CLICKS = 'app_store_clicks';
  const ATTENTION_EVENTS_PER_IMPRESSION = 'attention_events_per_impression';
  const ATTENTION_EVENTS_UNQ_PER_REACH = 'attention_events_unq_per_reach';
  const AUCTION_BID = 'auction_bid';
  const AUCTION_COMPETITIVENESS = 'auction_competitiveness';
  const AUCTION_MAX_COMPETITOR_BID = 'auction_max_competitor_bid';
  const BODY_ASSET = 'body_asset';
  const BUYING_TYPE = 'buying_type';
  const CALL_TO_ACTION_ASSET = 'call_to_action_asset';
  const CALL_TO_ACTION_CLICKS = 'call_to_action_clicks';
  const CAMPAIGN_DELIVERY = 'campaign_delivery';
  const CAMPAIGN_END = 'campaign_end';
  const CAMPAIGN_ID = 'campaign_id';
  const CAMPAIGN_NAME = 'campaign_name';
  const CAMPAIGN_START = 'campaign_start';
  const CANCEL_SUBSCRIPTION_ACTIONS = 'cancel_subscription_actions';
  const CANVAS_AVG_VIEW_PERCENT = 'canvas_avg_view_percent';
  const CANVAS_AVG_VIEW_TIME = 'canvas_avg_view_time';
  const CARD_VIEWS = 'card_views';
  const CATALOG_SEGMENT_ACTIONS = 'catalog_segment_actions';
  const CATALOG_SEGMENT_VALUE_IN_CATALOG_CURRENCY = 'catalog_segment_value_in_catalog_currency';
  const CATALOG_SEGMENT_VALUE_MOBILE_PURCHASE_ROAS = 'catalog_segment_value_mobile_purchase_roas';
  const CATALOG_SEGMENT_VALUE_WEBSITE_PURCHASE_ROAS = 'catalog_segment_value_website_purchase_roas';
  const CLICKS = 'clicks';
  const CONDITIONAL_TIME_SPENT_MS_OVER_10S_ACTIONS = 'conditional_time_spent_ms_over_10s_actions';
  const CONDITIONAL_TIME_SPENT_MS_OVER_15S_ACTIONS = 'conditional_time_spent_ms_over_15s_actions';
  const CONDITIONAL_TIME_SPENT_MS_OVER_2S_ACTIONS = 'conditional_time_spent_ms_over_2s_actions';
  const CONDITIONAL_TIME_SPENT_MS_OVER_3S_ACTIONS = 'conditional_time_spent_ms_over_3s_actions';
  const CONDITIONAL_TIME_SPENT_MS_OVER_6S_ACTIONS = 'conditional_time_spent_ms_over_6s_actions';
  const CONTACT_ACTIONS = 'contact_actions';
  const CONTACT_VALUE = 'contact_value';
  const CONVERSION_VALUES = 'conversion_values';
  const CONVERSIONS = 'conversions';
  const COST_PER_10_SEC_VIDEO_VIEW = 'cost_per_10_sec_video_view';
  const COST_PER_15_SEC_VIDEO_VIEW = 'cost_per_15_sec_video_view';
  const COST_PER_2_SEC_CONTINUOUS_VIDEO_VIEW = 'cost_per_2_sec_continuous_video_view';
  const COST_PER_ACTION_RESULT = 'cost_per_action_result';
  const COST_PER_ACTION_TYPE = 'cost_per_action_type';
  const COST_PER_AD_CLICK = 'cost_per_ad_click';
  const COST_PER_COMPLETED_VIDEO_VIEW = 'cost_per_completed_video_view';
  const COST_PER_CONTACT = 'cost_per_contact';
  const COST_PER_CONVERSION = 'cost_per_conversion';
  const COST_PER_CUSTOMIZE_PRODUCT = 'cost_per_customize_product';
  const COST_PER_DDA_COUNTBY_CONVS = 'cost_per_dda_countby_convs';
  const COST_PER_DONATE = 'cost_per_donate';
  const COST_PER_DWELL = 'cost_per_dwell';
  const COST_PER_DWELL_3_SEC = 'cost_per_dwell_3_sec';
  const COST_PER_DWELL_5_SEC = 'cost_per_dwell_5_sec';
  const COST_PER_DWELL_7_SEC = 'cost_per_dwell_7_sec';
  const COST_PER_ESTIMATED_AD_RECALLERS = 'cost_per_estimated_ad_recallers';
  const COST_PER_FIND_LOCATION = 'cost_per_find_location';
  const COST_PER_INLINE_LINK_CLICK = 'cost_per_inline_link_click';
  const COST_PER_INLINE_POST_ENGAGEMENT = 'cost_per_inline_post_engagement';
  const COST_PER_ONE_THOUSAND_AD_IMPRESSION = 'cost_per_one_thousand_ad_impression';
  const COST_PER_OUTBOUND_CLICK = 'cost_per_outbound_click';
  const COST_PER_SCHEDULE = 'cost_per_schedule';
  const COST_PER_START_TRIAL = 'cost_per_start_trial';
  const COST_PER_SUBMIT_APPLICATION = 'cost_per_submit_application';
  const COST_PER_SUBSCRIBE = 'cost_per_subscribe';
  const COST_PER_THRUPLAY = 'cost_per_thruplay';
  const COST_PER_TOTAL_ACTION = 'cost_per_total_action';
  const COST_PER_UNIQUE_ACTION_TYPE = 'cost_per_unique_action_type';
  const COST_PER_UNIQUE_CLICK = 'cost_per_unique_click';
  const COST_PER_UNIQUE_CONVERSION = 'cost_per_unique_conversion';
  const COST_PER_UNIQUE_INLINE_LINK_CLICK = 'cost_per_unique_inline_link_click';
  const COST_PER_UNIQUE_OUTBOUND_CLICK = 'cost_per_unique_outbound_click';
  const COUNTRY = 'country';
  const CPC = 'cpc';
  const CPM = 'cpm';
  const CPP = 'cpp';
  const CREATED_TIME = 'created_time';
  const CREATIVE_FINGERPRINT = 'creative_fingerprint';
  const CTR = 'ctr';
  const CUSTOMIZE_PRODUCT_ACTIONS = 'customize_product_actions';
  const CUSTOMIZE_PRODUCT_VALUE = 'customize_product_value';
  const DATE_START = 'date_start';
  const DATE_STOP = 'date_stop';
  const DDA_COUNTBY_CONVS = 'dda_countby_convs';
  const DEDUPING_1ST_SOURCE_RATIO = 'deduping_1st_source_ratio';
  const DEDUPING_2ND_SOURCE_RATIO = 'deduping_2nd_source_ratio';
  const DEDUPING_3RD_SOURCE_RATIO = 'deduping_3rd_source_ratio';
  const DEDUPING_RATIO = 'deduping_ratio';
  const DEEPLINK_CLICKS = 'deeplink_clicks';
  const DESCRIPTION_ASSET = 'description_asset';
  const DEVICE_PLATFORM = 'device_platform';
  const DMA = 'dma';
  const DONATE_ACTIONS = 'donate_actions';
  const DONATE_VALUE = 'donate_value';
  const DWELL_3_SEC = 'dwell_3_sec';
  const DWELL_5_SEC = 'dwell_5_sec';
  const DWELL_7_SEC = 'dwell_7_sec';
  const DWELL_RATE = 'dwell_rate';
  const EARNED_IMPRESSION = 'earned_impression';
  const ESTIMATED_AD_RECALL_RATE = 'estimated_ad_recall_rate';
  const ESTIMATED_AD_RECALL_RATE_LOWER_BOUND = 'estimated_ad_recall_rate_lower_bound';
  const ESTIMATED_AD_RECALL_RATE_UPPER_BOUND = 'estimated_ad_recall_rate_upper_bound';
  const ESTIMATED_AD_RECALLERS = 'estimated_ad_recallers';
  const ESTIMATED_AD_RECALLERS_LOWER_BOUND = 'estimated_ad_recallers_lower_bound';
  const ESTIMATED_AD_RECALLERS_UPPER_BOUND = 'estimated_ad_recallers_upper_bound';
  const FIND_LOCATION_ACTIONS = 'find_location_actions';
  const FIND_LOCATION_VALUE = 'find_location_value';
  const FREQUENCY = 'frequency';
  const FREQUENCY_VALUE = 'frequency_value';
  const FULL_VIEW_IMPRESSIONS = 'full_view_impressions';
  const FULL_VIEW_REACH = 'full_view_reach';
  const GENDER = 'gender';
  const GENDER_TARGETING = 'gender_targeting';
  const HOURLY_STATS_AGGREGATED_BY_ADVERTISER_TIME_ZONE = 'hourly_stats_aggregated_by_advertiser_time_zone';
  const HOURLY_STATS_AGGREGATED_BY_AUDIENCE_TIME_ZONE = 'hourly_stats_aggregated_by_audience_time_zone';
  const IMAGE_ASSET = 'image_asset';
  const IMPRESSION_DEVICE = 'impression_device';
  const IMPRESSIONS = 'impressions';
  const IMPRESSIONS_AUTO_REFRESH = 'impressions_auto_refresh';
  const IMPRESSIONS_GROSS = 'impressions_gross';
  const INLINE_LINK_CLICK_CTR = 'inline_link_click_ctr';
  const INLINE_LINK_CLICKS = 'inline_link_clicks';
  const INLINE_POST_ENGAGEMENT = 'inline_post_engagement';
  const INSTANT_EXPERIENCE_CLICKS_TO_OPEN = 'instant_experience_clicks_to_open';
  const INSTANT_EXPERIENCE_CLICKS_TO_START = 'instant_experience_clicks_to_start';
  const INSTANT_EXPERIENCE_OUTBOUND_CLICKS = 'instant_experience_outbound_clicks';
  const INTERACTIVE_COMPONENT_TAP = 'interactive_component_tap';
  const LABELS = 'labels';
  const LINK_URL_ASSET = 'link_url_asset';
  const LOCATION = 'location';
  const MEDIA_ASSET = 'media_asset';
  const MOBILE_APP_PURCHASE_ROAS = 'mobile_app_purchase_roas';
  const NEWSFEED_AVG_POSITION = 'newsfeed_avg_position';
  const NEWSFEED_CLICKS = 'newsfeed_clicks';
  const NEWSFEED_IMPRESSIONS = 'newsfeed_impressions';
  const OBJECTIVE = 'objective';
  const OPTIMIZATION_GOAL = 'optimization_goal';
  const OUTBOUND_CLICKS = 'outbound_clicks';
  const OUTBOUND_CLICKS_CTR = 'outbound_clicks_ctr';
  const PERFORMANCE_INDICATOR = 'performance_indicator';
  const PLACE_PAGE_ID = 'place_page_id';
  const PLACE_PAGE_NAME = 'place_page_name';
  const PLACEMENT = 'placement';
  const PLATFORM_POSITION = 'platform_position';
  const PRODUCT_ID = 'product_id';
  const PUBLISHER_PLATFORM = 'publisher_platform';
  const PURCHASE_ROAS = 'purchase_roas';
  const QUALITY_SCORE_ECTR = 'quality_score_ectr';
  const QUALITY_SCORE_ECVR = 'quality_score_ecvr';
  const QUALITY_SCORE_ENFBR = 'quality_score_enfbr';
  const QUALITY_SCORE_ORGANIC = 'quality_score_organic';
  const REACH = 'reach';
  const RECURRING_SUBSCRIPTION_PAYMENT_ACTIONS = 'recurring_subscription_payment_actions';
  const REGION = 'region';
  const RELEVANCE_SCORE = 'relevance_score';
  const RULE_ASSET = 'rule_asset';
  const SCHEDULE_ACTIONS = 'schedule_actions';
  const SCHEDULE_VALUE = 'schedule_value';
  const SOCIAL_SPEND = 'social_spend';
  const SPEND = 'spend';
  const START_TRIAL_ACTIONS = 'start_trial_actions';
  const START_TRIAL_VALUE = 'start_trial_value';
  const SUBMIT_APPLICATION_ACTIONS = 'submit_application_actions';
  const SUBMIT_APPLICATION_VALUE = 'submit_application_value';
  const SUBSCRIBE_ACTIONS = 'subscribe_actions';
  const SUBSCRIBE_VALUE = 'subscribe_value';
  const THUMB_STOPS = 'thumb_stops';
  const TITLE_ASSET = 'title_asset';
  const TODAY_SPEND = 'today_spend';
  const TOTAL_ACTION_VALUE = 'total_action_value';
  const TOTAL_ACTIONS = 'total_actions';
  const TOTAL_UNIQUE_ACTIONS = 'total_unique_actions';
  const UNIQUE_ACTIONS = 'unique_actions';
  const UNIQUE_CLICKS = 'unique_clicks';
  const UNIQUE_CONVERSIONS = 'unique_conversions';
  const UNIQUE_CTR = 'unique_ctr';
  const UNIQUE_IMPRESSIONS = 'unique_impressions';
  const UNIQUE_INLINE_LINK_CLICK_CTR = 'unique_inline_link_click_ctr';
  const UNIQUE_INLINE_LINK_CLICKS = 'unique_inline_link_clicks';
  const UNIQUE_LINK_CLICKS_CTR = 'unique_link_clicks_ctr';
  const UNIQUE_OUTBOUND_CLICKS = 'unique_outbound_clicks';
  const UNIQUE_OUTBOUND_CLICKS_CTR = 'unique_outbound_clicks_ctr';
  const UNIQUE_VIDEO_CONTINUOUS_2_SEC_WATCHED_ACTIONS = 'unique_video_continuous_2_sec_watched_actions';
  const UNIQUE_VIDEO_VIEW_10_SEC = 'unique_video_view_10_sec';
  const UNIQUE_VIDEO_VIEW_15_SEC = 'unique_video_view_15_sec';
  const UPDATED_TIME = 'updated_time';
  const VIDEO_10_SEC_WATCHED_ACTIONS = 'video_10_sec_watched_actions';
  const VIDEO_15_SEC_WATCHED_ACTIONS = 'video_15_sec_watched_actions';
  const VIDEO_30_SEC_WATCHED_ACTIONS = 'video_30_sec_watched_actions';
  const VIDEO_ASSET = 'video_asset';
  const VIDEO_AVG_PERCENT_WATCHED_ACTIONS = 'video_avg_percent_watched_actions';
  const VIDEO_AVG_TIME_WATCHED_ACTIONS = 'video_avg_time_watched_actions';
  const VIDEO_COMPLETE_WATCHED_ACTIONS = 'video_complete_watched_actions';
  const VIDEO_COMPLETED_VIEW_OR_15S_PASSED_ACTIONS = 'video_completed_view_or_15s_passed_actions';
  const VIDEO_CONTINUOUS_2_SEC_WATCHED_ACTIONS = 'video_continuous_2_sec_watched_actions';
  const VIDEO_P100_WATCHED_ACTIONS = 'video_p100_watched_actions';
  const VIDEO_P25_WATCHED_ACTIONS = 'video_p25_watched_actions';
  const VIDEO_P50_WATCHED_ACTIONS = 'video_p50_watched_actions';
  const VIDEO_P75_WATCHED_ACTIONS = 'video_p75_watched_actions';
  const VIDEO_P95_WATCHED_ACTIONS = 'video_p95_watched_actions';
  const VIDEO_PLAY_ACTIONS = 'video_play_actions';
  const VIDEO_PLAY_CURVE_ACTIONS = 'video_play_curve_actions';
  const VIDEO_PLAY_RETENTION_0_TO_15S_ACTIONS = 'video_play_retention_0_to_15s_actions';
  const VIDEO_PLAY_RETENTION_20_TO_60S_ACTIONS = 'video_play_retention_20_to_60s_actions';
  const VIDEO_PLAY_RETENTION_GRAPH_ACTIONS = 'video_play_retention_graph_actions';
  const VIDEO_THRUPLAY_WATCHED_ACTIONS = 'video_thruplay_watched_actions';
  const VIDEO_TIME_WATCHED_ACTIONS = 'video_time_watched_actions';
  const WEBSITE_CLICKS = 'website_clicks';
  const WEBSITE_CTR = 'website_ctr';
  const WEBSITE_PURCHASE_ROAS = 'website_purchase_roas';
  const WISH_BID = 'wish_bid';

  public function getFieldTypes() {
    return array(
      'account_currency' => 'string',
      'account_id' => 'string',
      'account_name' => 'string',
      'action_values' => 'list<AdsActionStats>',
      'actions' => 'list<AdsActionStats>',
      'actions_per_impression' => 'string',
      'actions_results' => 'AdsActionStats',
      'activity_recency' => 'string',
      'ad_bid_type' => 'string',
      'ad_bid_value' => 'string',
      'ad_click_actions' => 'list<AdsActionStats>',
      'ad_delivery' => 'string',
      'ad_format_asset' => 'string',
      'ad_id' => 'string',
      'ad_impression_actions' => 'list<AdsActionStats>',
      'ad_name' => 'string',
      'adset_bid_type' => 'string',
      'adset_bid_value' => 'string',
      'adset_budget_type' => 'string',
      'adset_budget_value' => 'string',
      'adset_delivery' => 'string',
      'adset_end' => 'string',
      'adset_id' => 'string',
      'adset_name' => 'string',
      'adset_start' => 'string',
      'age' => 'string',
      'age_targeting' => 'string',
      'amount_in_catalog_currency' => 'list<AdsActionStats>',
      'app_store_clicks' => 'string',
      'attention_events_per_impression' => 'string',
      'attention_events_unq_per_reach' => 'string',
      'auction_bid' => 'string',
      'auction_competitiveness' => 'string',
      'auction_max_competitor_bid' => 'string',
      'body_asset' => 'Object',
      'buying_type' => 'string',
      'call_to_action_asset' => 'Object',
      'call_to_action_clicks' => 'string',
      'campaign_delivery' => 'string',
      'campaign_end' => 'string',
      'campaign_id' => 'string',
      'campaign_name' => 'string',
      'campaign_start' => 'string',
      'cancel_subscription_actions' => 'list<AdsActionStats>',
      'canvas_avg_view_percent' => 'string',
      'canvas_avg_view_time' => 'string',
      'card_views' => 'string',
      'catalog_segment_actions' => 'list<AdsActionStats>',
      'catalog_segment_value_in_catalog_currency' => 'list<AdsActionStats>',
      'catalog_segment_value_mobile_purchase_roas' => 'list<AdsActionStats>',
      'catalog_segment_value_website_purchase_roas' => 'list<AdsActionStats>',
      'clicks' => 'string',
      'conditional_time_spent_ms_over_10s_actions' => 'list<AdsActionStats>',
      'conditional_time_spent_ms_over_15s_actions' => 'list<AdsActionStats>',
      'conditional_time_spent_ms_over_2s_actions' => 'list<AdsActionStats>',
      'conditional_time_spent_ms_over_3s_actions' => 'list<AdsActionStats>',
      'conditional_time_spent_ms_over_6s_actions' => 'list<AdsActionStats>',
      'contact_actions' => 'list<AdsActionStats>',
      'contact_value' => 'list<AdsActionStats>',
      'conversion_values' => 'list<AdsActionStats>',
      'conversions' => 'list<AdsActionStats>',
      'cost_per_10_sec_video_view' => 'list<AdsActionStats>',
      'cost_per_15_sec_video_view' => 'list<AdsActionStats>',
      'cost_per_2_sec_continuous_video_view' => 'list<AdsActionStats>',
      'cost_per_action_result' => 'AdsActionStats',
      'cost_per_action_type' => 'list<AdsActionStats>',
      'cost_per_ad_click' => 'list<AdsActionStats>',
      'cost_per_completed_video_view' => 'list<AdsActionStats>',
      'cost_per_contact' => 'list<AdsActionStats>',
      'cost_per_conversion' => 'list<AdsActionStats>',
      'cost_per_customize_product' => 'list<AdsActionStats>',
      'cost_per_dda_countby_convs' => 'string',
      'cost_per_donate' => 'list<AdsActionStats>',
      'cost_per_dwell' => 'string',
      'cost_per_dwell_3_sec' => 'string',
      'cost_per_dwell_5_sec' => 'string',
      'cost_per_dwell_7_sec' => 'string',
      'cost_per_estimated_ad_recallers' => 'string',
      'cost_per_find_location' => 'list<AdsActionStats>',
      'cost_per_inline_link_click' => 'string',
      'cost_per_inline_post_engagement' => 'string',
      'cost_per_one_thousand_ad_impression' => 'list<AdsActionStats>',
      'cost_per_outbound_click' => 'list<AdsActionStats>',
      'cost_per_schedule' => 'list<AdsActionStats>',
      'cost_per_start_trial' => 'list<AdsActionStats>',
      'cost_per_submit_application' => 'list<AdsActionStats>',
      'cost_per_subscribe' => 'list<AdsActionStats>',
      'cost_per_thruplay' => 'list<AdsActionStats>',
      'cost_per_total_action' => 'string',
      'cost_per_unique_action_type' => 'list<AdsActionStats>',
      'cost_per_unique_click' => 'string',
      'cost_per_unique_conversion' => 'list<AdsActionStats>',
      'cost_per_unique_inline_link_click' => 'string',
      'cost_per_unique_outbound_click' => 'list<AdsActionStats>',
      'country' => 'string',
      'cpc' => 'string',
      'cpm' => 'string',
      'cpp' => 'string',
      'created_time' => 'string',
      'creative_fingerprint' => 'string',
      'ctr' => 'string',
      'customize_product_actions' => 'list<AdsActionStats>',
      'customize_product_value' => 'list<AdsActionStats>',
      'date_start' => 'string',
      'date_stop' => 'string',
      'dda_countby_convs' => 'string',
      'deduping_1st_source_ratio' => 'string',
      'deduping_2nd_source_ratio' => 'string',
      'deduping_3rd_source_ratio' => 'string',
      'deduping_ratio' => 'string',
      'deeplink_clicks' => 'string',
      'description_asset' => 'Object',
      'device_platform' => 'string',
      'dma' => 'string',
      'donate_actions' => 'list<AdsActionStats>',
      'donate_value' => 'list<AdsActionStats>',
      'dwell_3_sec' => 'string',
      'dwell_5_sec' => 'string',
      'dwell_7_sec' => 'string',
      'dwell_rate' => 'string',
      'earned_impression' => 'string',
      'estimated_ad_recall_rate' => 'string',
      'estimated_ad_recall_rate_lower_bound' => 'string',
      'estimated_ad_recall_rate_upper_bound' => 'string',
      'estimated_ad_recallers' => 'string',
      'estimated_ad_recallers_lower_bound' => 'string',
      'estimated_ad_recallers_upper_bound' => 'string',
      'find_location_actions' => 'list<AdsActionStats>',
      'find_location_value' => 'list<AdsActionStats>',
      'frequency' => 'string',
      'frequency_value' => 'string',
      'full_view_impressions' => 'string',
      'full_view_reach' => 'string',
      'gender' => 'string',
      'gender_targeting' => 'string',
      'hourly_stats_aggregated_by_advertiser_time_zone' => 'string',
      'hourly_stats_aggregated_by_audience_time_zone' => 'string',
      'image_asset' => 'Object',
      'impression_device' => 'string',
      'impressions' => 'string',
      'impressions_auto_refresh' => 'string',
      'impressions_gross' => 'string',
      'inline_link_click_ctr' => 'string',
      'inline_link_clicks' => 'string',
      'inline_post_engagement' => 'string',
      'instant_experience_clicks_to_open' => 'string',
      'instant_experience_clicks_to_start' => 'string',
      'instant_experience_outbound_clicks' => 'string',
      'interactive_component_tap' => 'list<AdsActionStats>',
      'labels' => 'string',
      'link_url_asset' => 'Object',
      'location' => 'string',
      'media_asset' => 'Object',
      'mobile_app_purchase_roas' => 'list<AdsActionStats>',
      'newsfeed_avg_position' => 'string',
      'newsfeed_clicks' => 'string',
      'newsfeed_impressions' => 'string',
      'objective' => 'string',
      'optimization_goal' => 'string',
      'outbound_clicks' => 'list<AdsActionStats>',
      'outbound_clicks_ctr' => 'list<AdsActionStats>',
      'performance_indicator' => 'string',
      'place_page_id' => 'string',
      'place_page_name' => 'string',
      'placement' => 'string',
      'platform_position' => 'string',
      'product_id' => 'string',
      'publisher_platform' => 'string',
      'purchase_roas' => 'list<AdsActionStats>',
      'quality_score_ectr' => 'string',
      'quality_score_ecvr' => 'string',
      'quality_score_enfbr' => 'string',
      'quality_score_organic' => 'string',
      'reach' => 'string',
      'recurring_subscription_payment_actions' => 'list<AdsActionStats>',
      'region' => 'string',
      'relevance_score' => 'AdgroupRelevanceScore',
      'rule_asset' => 'Object',
      'schedule_actions' => 'list<AdsActionStats>',
      'schedule_value' => 'list<AdsActionStats>',
      'social_spend' => 'string',
      'spend' => 'string',
      'start_trial_actions' => 'list<AdsActionStats>',
      'start_trial_value' => 'list<AdsActionStats>',
      'submit_application_actions' => 'list<AdsActionStats>',
      'submit_application_value' => 'list<AdsActionStats>',
      'subscribe_actions' => 'list<AdsActionStats>',
      'subscribe_value' => 'list<AdsActionStats>',
      'thumb_stops' => 'string',
      'title_asset' => 'Object',
      'today_spend' => 'string',
      'total_action_value' => 'string',
      'total_actions' => 'string',
      'total_unique_actions' => 'string',
      'unique_actions' => 'list<AdsActionStats>',
      'unique_clicks' => 'string',
      'unique_conversions' => 'list<AdsActionStats>',
      'unique_ctr' => 'string',
      'unique_impressions' => 'string',
      'unique_inline_link_click_ctr' => 'string',
      'unique_inline_link_clicks' => 'string',
      'unique_link_clicks_ctr' => 'string',
      'unique_outbound_clicks' => 'list<AdsActionStats>',
      'unique_outbound_clicks_ctr' => 'list<AdsActionStats>',
      'unique_video_continuous_2_sec_watched_actions' => 'list<AdsActionStats>',
      'unique_video_view_10_sec' => 'list<AdsActionStats>',
      'unique_video_view_15_sec' => 'list<AdsActionStats>',
      'updated_time' => 'string',
      'video_10_sec_watched_actions' => 'list<AdsActionStats>',
      'video_15_sec_watched_actions' => 'list<AdsActionStats>',
      'video_30_sec_watched_actions' => 'list<AdsActionStats>',
      'video_asset' => 'Object',
      'video_avg_percent_watched_actions' => 'list<AdsActionStats>',
      'video_avg_time_watched_actions' => 'list<AdsActionStats>',
      'video_complete_watched_actions' => 'list<AdsActionStats>',
      'video_completed_view_or_15s_passed_actions' => 'list<AdsActionStats>',
      'video_continuous_2_sec_watched_actions' => 'list<AdsActionStats>',
      'video_p100_watched_actions' => 'list<AdsActionStats>',
      'video_p25_watched_actions' => 'list<AdsActionStats>',
      'video_p50_watched_actions' => 'list<AdsActionStats>',
      'video_p75_watched_actions' => 'list<AdsActionStats>',
      'video_p95_watched_actions' => 'list<AdsActionStats>',
      'video_play_actions' => 'list<AdsActionStats>',
      'video_play_curve_actions' => 'list<Object>',
      'video_play_retention_0_to_15s_actions' => 'list<Object>',
      'video_play_retention_20_to_60s_actions' => 'list<Object>',
      'video_play_retention_graph_actions' => 'list<Object>',
      'video_thruplay_watched_actions' => 'list<AdsActionStats>',
      'video_time_watched_actions' => 'list<AdsActionStats>',
      'website_clicks' => 'string',
      'website_ctr' => 'list<AdsActionStats>',
      'website_purchase_roas' => 'list<AdsActionStats>',
      'wish_bid' => 'string',
    );
  }
}
