<?php $__env->startSection('content'); ?>
    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <?php if(session('message')): ?>
                            <div class="alert-danger notification">
                                <ul style="list-style: none;text-align: center;">
                                    <li><?php echo e(session('message')); ?></li>
                                </ul>
                            </div>
                        <?php endif; ?>
                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                    <ul>
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                        <div class="card-header fix-header bottom-card">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">Thông tin cá nhân</h4>
                            </div>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-header fix-header"></div>
                        <div class="card-content collapse show">
                            <form action="/user-profile" method="post" enctype="multipart/form-data" autocomplete="off">
                                <?php echo csrf_field(); ?>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="row">
                                                <div class="col-2">Tên tài khoản</div>
                                                <div class="col-8"><input type="text" class="square form-control" readonly value="<?php echo e($user->username); ?>"></div>
                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Nhóm quyền</div>
                                                <div class="col-8">
                                                    <input type="text" class="square form-control" readonly
                                                                          value="<?php echo e($user->department_id == \App\Constants\DepartmentConstant::ADMIN ? 'Admin'
                                                                          :($user->department_id == \App\Constants\DepartmentConstant::CEO ? 'CEO'
                                                                          :($user->department_id == \App\Constants\DepartmentConstant::SALE ? 'Sale'
                                                                          :($user->department_id == \App\Constants\DepartmentConstant::MARKETING ? 'Marketing'
                                                                          :($user->department_id == \App\Constants\DepartmentConstant::ACCOUNTING ? 'Kế toán'
                                                                          :($user->department_id == \App\Constants\DepartmentConstant::WAREHOUSE ? 'Kho':'')))))); ?>">
                                                </div>
                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Họ và tên</div>
                                                

                                                <div class="col-8 <?php echo e($errors->has('name')?'has-error':''); ?>">
                                                    <input type="text" name="name" class="square form-control"
                                                           value="<?php echo e(!empty($user)?$user->name:old('name')); ?>">
                                                    <?php if($errors->has('name')): ?>
                                                        <div class="red"><?php echo e($errors->first('name')); ?></div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Mã định danh</div>
                                                <div class="col-8"><input type="text" class="square form-control" readonly value="<?php echo e($user->id); ?>"></div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="row">
                                                <div class="col-2">Email</div>
                                                <div class="col-8 <?php echo e($errors->has('email')?'has-error':''); ?>">
                                                    <input type="hidden" class="emailValue" value="<?php echo e(!empty($user)?$user->email : ''); ?>">
                                                    <input type="email" name="email" class="square form-control email"
                                                           value="<?php echo e(!empty($user)?$user->email:old('email')); ?>">
                                                    <?php if($errors->has('email')): ?>
                                                        <div class="red"><?php echo e($errors->first('email')); ?></div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Số điện thoại</div>
                                                

                                                <div class="col-8 <?php echo e($errors->has('phone')?'has-error':''); ?>">
                                                    <input type="hidden" class="phonelValue" value="<?php echo e(!empty($user)?$user->phone : ''); ?>">

                                                    <input type="text" name="phone" class="square form-control phone"
                                                           value="<?php echo e(!empty($user)?$user->phone:old('phone')); ?>">
                                                    <?php if($errors->has('phone')): ?>
                                                        <div class="red"><?php echo e($errors->first('phone')); ?></div>
                                                    <?php endif; ?>
                                                </div>


                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Mật khẩu</div>
                                                <div class="col-8"><input type="password" class="square form-control password" name="password" id="password"></div>
                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Nhập lại mật khẩu</div>
                                                <div class="col-8"><input type="password" class="square form-control confirm_password" name="confirm_password" id="confirm_password"></div>
                                            </div>

                                            <div class="row mt-1">
                                                <div class="col-2">Ảnh đại diện</div>
                                                <div class="col-8">
                                                    <div class="customer-avatar">
                                                        <div class="avatar-wrapper">
                                                            <button type="button" class="btn btn-primary action-upload">Chọn ảnh</button>
                                                            <input type="file" name="avatar" id="ip-upload-avatar" accept="image/*" style="visibility: hidden">
                                                        </div>
                                                        <img id="blah" src="<?php echo e($user->avatar ? url($user->avatar) : url('images/noavatar.jpg')); ?>" alt="" style="width: 120px;height: 120px;">
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-1">
                                        <div class="col-6">
                                            <div class="row">
                                                <div class="col-2"></div>
                                                <div class="col-8">
                                                    <button type="submit" class="btn btn-primary submit"><i class="fa fa-save"></i> Lưu</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php echo $__env->make('backend.layouts.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>

        $(document).ready(function () {
            let abc = $('.emailValue').val();
            if(!abc){
                $('.email').val('').change();
            }
            let abc1 = $('.phonelValue').val();
            if(!abc1){
                $('.email').val('').change();
            }
            $('.password').val('').change();
            $('.confirm_password').val('').change();
        })

        // $(document).on('focusout','#password,#confirm_password',function () {
        //     if($('#password').val() != ''){
        //         if($('#confirm_password').val() != '' && $('#password').val() !==  $('#confirm_password').val()){
        //             alertify.warning('Mật khẩu và xác thực chưa trùng nhau !');
        //         }
        //         if($('#password').val() !==  $('#confirm_password').val()){
        //             $('.submit').prop('disabled',true);
        //         } else {
        //             $('.submit').prop('disabled',false);
        //         }
        //     } else {
        //         $('.submit').prop('disabled',false);
        //
        //     }
        // })

        // $(document).on('focusout','#confirm_password',function () {
        //     if($('#password').val() != '' && $('#confirm_password').val() != ''){
        //         alertify.warning('Mật khẩu và xác thực chưa trùng nhau !');
        //         $('.submit').prop('disabled',true);
        //     } else {
        //         $('.submit').prop('disabled',false);
        //     }
        // })

        $(document).on('click','.action-upload',function(){
            $('#ip-upload-avatar').click();
        })

        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('#blah').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]); // convert to base64 string
            }
        }

        $("#ip-upload-avatar").change(function() {
            readURL(this);
        });

        $('.phoneNumber').on('change',function () {
            let str = $('.phoneNumber').val();
            let patt1 = /^[0-9]*$/g;
            let result = str.match(patt1);

            if(result == null){
                alertify.warning('Số điện thoại không đúng định dạng');
                $('.submit').prop('disabled',true);
            } else {
                $('.submit').prop('disabled',false);
            }
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cms-v2/resources/views/backend/pages/profile/index.blade.php ENDPATH**/ ?>