<?php
    $is_admin = \Auth::user()->department_id == \App\Constants\DepartmentConstant::ADMIN ? true : false;
    $is_ceo = \Auth::user()->department_id == \App\Constants\DepartmentConstant::CEO ? true : false;
    $is_leader = \Auth::user()->department_id == \App\Constants\DepartmentConstant::MARKETING && \Auth::user()->is_leader==\App\Constants\StatusCode::ACTIVE ? true : false;
    $is_sale = \Auth::user()->department_id == \App\Constants\DepartmentConstant::SALE ? true : false;
    $is_cskh = \Auth::user()->department_id == \App\Constants\DepartmentConstant::CSKH ? true : false;

?>
<?php $__env->startSection('content'); ?>
    <style>
        .modal-header.bg-main {
            height: 35px;
        }

        .modal-header.bg-main .modal-title {
            line-height: 10px;
            font-size: 18px;
        }

        .fam-container {
            bottom: 3%;
            position: fixed;
            margin: 1em;
            left: 2.5%;
            z-index: 9999;
            width: 100px;
        }

        .buttons {
            font-size: 11px;
            text-align: center;
            box-shadow: 0px 5px 11px -2px rgba(0, 0, 0, 0.18), 0px 4px 12px -7px rgba(0, 0, 0, 0.15);
            border-radius: 50%;
            display: block;
            width: 56px;
            height: 56px;
            margin: 20px auto 0;
            position: relative;
            -webkit-transition: all .1s ease-out;
            transition: all .1s ease-out;
        }

        .buttons i.fa {
            font-size: 18px;
            color: white;
            line-height: 40px;
        }

        .fam-primary {
            background: #6ea543;
        }

        .fam-warning {
            background: #f89406;
        }

        .fam-container:hover .buttons:not(:last-child) {
            margin: 20px auto 0;
            width: 40px;
            height: 40px;
            opacity: 1;
            -webkit-transform: none;
            -ms-transform: none;
            transform: none;
            margin: 15px auto 0;
        }

        .buttons:not(:last-child) {
            width: 0px;
            height: 0px;
            margin: 0px auto 0;
            opacity: 0;
            -webkit-transform: translateY(50px);
            -ms-transform: translateY(50px);
            transform: translateY(50px);
        }

        .buttons:nth-last-child(1) {
            transition-delay: 25ms;
            background-size: contain;
            background: #6ea543;
        }

        .buttons:nth-last-child(1) i {
            color: white;
            font-size: 24px;
            line-height: 55px;
        }

        .notice {
            background-color: #ffffee;
            border: 1px solid #ffaa00;
            border-radius: 2px;
            color: #333;
            font-size: 11px;
            padding: 6px 10px 4px;
        }

        th.text-center {
            min-width: 155px;
        }
    </style>

    <nav class="fam-container">

        <?php if($is_admin): ?>
            <a id="btn_import" class="buttons bg-success" data-toggle="tooltip" data-placement="right"
               title="Tải danh sách khách hàng">
                <i class="fa fa-cloud-upload"></i>
            </a>

            <a id="DanhSachContact_btnExport" class="buttons fam-primary" data-toggle="tooltip" data-placement="right"
               title="Xuất excel kiểu 1">
                <i class="fa fa-calendar-check-o"></i>
            </a>
        <?php endif; ?>
        <?php if($is_admin||$is_ceo||$is_leader || $is_sale ||$is_cskh): ?>
            <a id="DanhSachContact_btnPhanBoLai" class="buttons fam-warning" data-toggle="tooltip"
               data-placement="right" title="Phân bổ lại ngay lập tức"><i class="fa fa-calendar-times-o"></i>
            </a>
        <?php endif; ?>
        <?php if($is_admin||$is_ceo||$is_leader): ?>
            <a id="UpdateSource" class="buttons fam-warning" data-toggle="tooltip"
               data-placement="right" title="Phân bổ lại source"><i class="fa fa-calendar-times-o"></i>
            </a>
        <?php endif; ?>
        <a class="buttons" tooltip="Share" href="#"><i class="fa fa-bars"></i></a>
    </nav>


    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <?php echo Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')); ?>

                        <div class="card-header fix-header bottom-card add-paginate">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">4.3 Hồ sơ khách hàng</h4>
                                <div class="col-lg-3 col-md-6">
                                    <input type="text" class="form-control square" id="search_value"
                                           placeholder="Số điện thoại" name="search">
                                </div>
                                <button class="btn btn-primary searchData"><i class="fa fa-search"></i> Tìm kiếm
                                </button>
                            </div>
                            <?php echo $__env->make('backend.sale.customer.dropdownFilter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        </div>
                        <?php echo e(Form::close()); ?>

                        <div class="card-content collapse show">
                            <div class="card-body">
                                <?php echo $__env->make('backend.sale.customer.ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>
        <!-- // card-actions section end -->
        <div class="modal fade text-left" id="add_new" tabindex="-1" role="dialog"
             aria-labelledby="myModalLabel35"
             style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header bg-main">
                        <h5 class="modal-title" id="myModalLabel35"> Cập nhật số seeding</h5>
                        <button type="button" class="close" data-dismiss="modal"
                                aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <?php echo $__env->make('backend.marketing.seeding_number._form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>

    </div>
    <?php echo $__env->make('backend.sale.customer.modal_phan_bo_data', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.sale.customer.modal_phan_bo_source', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.sale.operation.modal_list_order', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.sale.customer.import', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('components.tin_nhan_noi_bo.modal_internal_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('components.lich_su_tac_nghiep.modal_history_operation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php echo $__env->make('backend.layouts.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script type="text/javascript" src="<?php echo e(asset('js/moment.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/daterangepicker.min.js')); ?>"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/daterangepicker.css')); ?>"/>
    <script type="text/javascript" src="<?php echo e(asset('js/dateranger-config.js')); ?>"></script>
    <script src="/js/file_upload.js"></script>

    <script>

        $(document).ready(function () {
            $("#checkAll").click(function () {
                $('input:checkbox').not(this).prop('checked', this.checked);
            });

            $("#btn_import").click(function () {
                $('#importDataCustomer').modal('show');
            });
        })


        $(document).on('click', '.btnDelete', function () {
            let favorite = [];
            $.each($("input[getData]:checked"), function () {
                favorite.push($(this).val());
            });
        })


        $(document).on('click', '.phoneNumber', function () {
            let phone = $(this).data('phone');
            let row = $(document).find('.list-order-phone-number');
            row.html('');
            let row_html = '';
            $.ajax({
                url: '/get-order-phoneNumber/' + phone,
                success: function (data) {
                    data.forEach(element => {

                        let source_name = element.source ? element.source.name : '';
                        let sale_name = element.sale ? element.sale.name : '';
                        let customer_status = element.customer_status ? element.customer_status.name : '';

                        if (element.orders.length > 0) {
                            element.orders.forEach(el => {
                                let order_status = el.order_status ? el.order_status.name : '';
                                let is_upsale = el.is_upsale ? '(Upsale)' : '';
                                let name = el.customer_name ? el.customer_name : element.name;
                                let total = new Intl.NumberFormat('de-IT', {
                                    style: 'currency',
                                    currency: 'VND'
                                }).format(el.total + el.advance_price);
                                row_html += `
                                     <tr>
                                        <td class="text-center">` + el.id + `</td>
                                        <td class="text-center">` + source_name + ` <br> ` + element.created_at + `</td>
                                        <td class="text-center">` + name + ' ' + is_upsale +`</td>
                                        <td class="text-center">` + element.message + `</td>
                                        <td class="text-center">` + sale_name + `</td>
                                        <td class="text-center">` + customer_status + `</td>
                                        <td class="text-center"></td>
                                        <td class="text-center">` + total + `</td>
                                        <td class="text-center">` + el.created_at + `</td>
                                        <td class="text-center">` + order_status + `</td>
                                        <td class="text-center"></td>
                                    </tr>
                                `
                            })

                        } else {
                            row_html += `
                                 <tr>
                                    <td class="text-center">` + element.id + `</td>
                                    <td class="text-center">` + element.source.name + ` <br> ` + element.created_at + `</td>
                                    <td class="text-center">
                                        ` + element.name + `
                                        <br>
                                        ` + element.phone + `
                                    </td>
                                    <td class="text-center">` + element.message + `</td>
                                    <td class="text-center">` + element.sale.name + `</td>
                                    <td class="text-center">` + customer_status + `</td>
                                    <td class="text-center"></td>
                                    <td class="text-center"></td>
                                    <td class="text-center"></td>
                                    <td class="text-center"></td>
                                </tr>
                            `
                        }

                    })
                    row.html(row_html);
                }
            });
            $('#modalPhoneNumber').modal('show');
        })


        var arr_id_kh = [];
        $(document).on('click', '#DanhSachContact_btnPhanBoLai', function () {
            $('.statusUpdate').val('').change();
            let favorite = [];
            $.each($("input:checked"), function () {
                favorite.push($(this).val());
            });

            if (favorite.length > 0) {
                $('#ModalPhanBoData').modal('show');
                arr_id_kh = favorite;
            } else {
                alertify.warning('Bạn chưa chọn khách hàng !')
            }
        })

        //phân bổ data
        $('.buttonPhanBo').on('click', function () {
            swal({
                title: 'Bạn chắc chắn muốn cập nhật?',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                showCloseButton: true,
            }).then(function () {
                $.ajax({
                    data: {
                        khach_hang_id: arr_id_kh,
                        user_id: $('#selectedSale').val(),
                        status: $('#selectedStatus').val()
                    },
                    url: '/ajax/sale/phan-bo-data',
                    method: 'put',
                    success: function (data) {
                        if (data) {
                            alertify.success('Phân bổ hoàn tất!');
                            $('.searchData').click();
                            $('#ModalPhanBoData').modal('hide');
                            // $("#mydiv").load(location.href + " #mydiv");
                            // setTimeout(function () {
                            //     window.location.reload();
                            // }, 500)
                        }
                    }
                });
            }, function (dismiss) {
            });
        })

        $('.searchData').click(function (e) {
            let value = $('#search_value').val();
            if (value && value.length < 5) {
                alertify.warning('Vui lòng nhập từ khoá có độ dài từ 5 ký tự', 3);
                return false;
            }
        });
        
        $('#UpdateSource').click(function (e) {
            let favorite = [];
            $.each($("input:checked"), function () {
                favorite.push($(this).val());
            });

            if (favorite.length > 0) {
                $('#ModalPhanBoSource').modal('show');
                arr_id_kh = favorite;
            } else {
                alertify.warning('Bạn chưa chọn khách hàng !')
            }
        })

        $(document).on('click','.buttonPhanBoSource',function () {
            swal({
                title: 'Bạn chắc chắn muốn cập nhật?',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                showCloseButton: true,
            }).then(function () {
                $.ajax({
                    data: {
                        arr_id_kh: arr_id_kh,
                        source_id: $('#selectedSource').val()
                    },
                    url: '/ajax/sale/phan-bo-source',
                    method: 'put',
                    success: function (data) {
                        if (data) {
                            alertify.success('Cập nhật thành công!');
                            $('.searchData').click();
                            $('#ModalPhanBoSource').modal('hide');
                        }
                    }
                });
            }, function (dismiss) {
            });

        })

    </script>
    <?php echo $__env->make('components.tin_nhan_noi_bo.js_internal_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('components.lich_su_tac_nghiep.js_history_operation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cms-v2/resources/views/backend/sale/customer/index.blade.php ENDPATH**/ ?>