<?php $__env->startSection('content'); ?>
    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <?php echo Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')); ?>

                        <div class="card-header fix-header bottom-card add-paginate">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">10.4 Danh sách cty</h4>
                                <div class="col-lg-3 col-md-6">
                                    <input type="hidden" name="start_date" id="start_date">
                                    <input type="hidden" name="end_date" id="end_date">
                                    <input id="reportrange" type="text" class="form-control square">
                                </div>

                                <div class="col-lg-2 col-md-6">
                                    <input name="phone" type="text" class="form-control square"
                                           placeholder="Tìm kiếm sdt ...">
                                </div>
                                <div class="col-lg-2 col-md-6">
                                    <input name="name" type="text" class="form-control square"
                                           placeholder="Tìm kiếm tên ...">
                                </div>
                                <button type="submit" class="btn btn-primary searchData" id="btnSearch"><i
                                        class="fa fa-search"></i> Tìm kiếm
                                </button>
                            </div>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        <?php echo e(Form::close()); ?>

                        <div class="card-content collapse show">
                            <div class="card-body">
                                <?php echo $__env->make('backend.system.company.ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.system.company._form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- // card-actions section end -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php echo $__env->make('backend.layouts.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        var company_code = <?php echo e($company_code); ?>;
        $().ready(function () {
            $("#validateForm").validate({
                rules: {
                    name: 'required',
                    phone: 'required',
                    prefix_username: 'required',
                },
                messages: {
                    name: "Vui lòng nhập tên !",
                    phone: "Vui lòng nhập SDT !",
                    prefix_username: "Vui lòng nhập prefix_username !",
                }
            })

        });

        $(document).on('click','.addCompany', function () {
            resetValue();
            $('#add_new').modal('show');
        })

        formatDate = function date2str(x, y) {
            var z = {
                M: x.getMonth() + 1,
                d: x.getDate(),
                h: x.getHours(),
                m: x.getMinutes(),
                s: x.getSeconds()
            };
            y = y.replace(/(M+|d+|h+|m+|s+)/g, function(v) {
                return ((v.length > 1 ? "0" : "") + z[v.slice(-1)]).slice(-2)
            });

            return y.replace(/(y+)/g, function(v) {
                return x.getFullYear().toString().slice(-v.length)
            });
        }

        $(document).on('click', '.edit', function () {
            // let company_code =
            let item = $(this).data('item');
            let form = $('#validateForm');
            form.attr('action', '/'+company_code +'/system/company/' + item.id );
            form.attr('method', 'POST');
            $('#add_new #myModalLabel').html('Cập nhật cty').change();
            form.append('<input name="_method" type="hidden" value="PUT" class="_method"/>');

            $('#validateForm #name').val(item.name);
            $('#validateForm #phone').val(item.phone);
            $('#validateForm #email').val(item.email);
            $('#validateForm #address').val(item.address);
            $('#validateForm #code_order').val(item.code_order);
            $('#validateForm #prefix_username').val(item.prefix_username);
            let abc = formatDate(new Date(item.date), 'dd/MM/yyyy hh:mm')
            $('#validateForm #demo').val(abc);
            $('#add_new').modal('show');
        })
        
        function resetValue() {
            $('#validateForm #name').val('');
            $('#validateForm #phone').val('');
            $('#validateForm #email').val('');
            $('#validateForm #address').val('');
            $('#validateForm #code_order').val('');
            $('#validateForm #prefix_username').val('');
            $('#add_new #myModalLabel').html('Thêm mới cty').change();
            let form = $('#validateForm');
            form.attr('action', '/'+company_code +'/system/company');
            $('._method').remove();
        }

        $(document).on('click','.status',function () {
            let id = $(this).data('id');
            let data_status = $(this).is(":checked");
            $.ajax({
                data: {
                    data_id: id,
                    data_status: data_status
                },
                url: '/'+company_code+'/system/update-status-company',
                method: 'put',
                success: function (data) {
                    if (data) {
                        alertify.success('Cập nhật thành công!');
                    }
                }
            });
        })
        $(document).on('click','.select-company',function () {
            let id = $(this).data('id');
            $.ajax({
                url : `/${company_code}/system/set-company`,
                method: 'post',
                data: {
                    id:id
                },
                success: (data)=> {
                    if(data){
                        let url = `/${data}/system/company`;
                        location.href = url;
                    } else {
                        alertify.error('đã có lỗi xảy ra');
                    }
                }
            })
        })
    </script>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/daterangepicker.css')); ?>"/>
    <script type="text/javascript" src="<?php echo e(asset('js/daterangepicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/dateranger-config.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cms-v2/resources/views/backend/system/company/index.blade.php ENDPATH**/ ?>