<?php $__env->startSection('content'); ?>
    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header fix-header bottom-card">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">Quản lý đội, nhóm</h4>
                                <div class="col-lg-3 col-md-6">
                                    <input type="text" class="form-control square"
                                           placeholder="Họ tên, số điện thoại">
                                </div>
                                <button class="btn btn-primary"><i class="fa fa-search"></i> Tìm kiếm</button>
                            </div>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-header fix-header"></div>
                        <div class="card-content collapse show">
                            <div class="card-body">
                                <div class="table-responsive tableFixHead table-bordered table-hover"
                                     style="width: 100%; overflow-x: auto;">
                                    <table class="table table-custom">
                                        <thead>
                                        <tr>
                                            <th class="text-center" style="width: 30px;">STT</th>
                                            <th class="text-center nowrap">Loại nhóm</th>
                                            <th class="text-center">Mã</th>
                                            <th class="text-center">Tên</th>
                                            <th class="text-center nowrap">Trưởng nhóm</th>
                                            <th class="text-center nowrap">Thành viên</th>
                                            <th class="text-center nowrap">Cập nhật</th>
                                            <th class="text-center nowrap">
                                                <a id="add_new" data-toggle="modal" data-target="#add_new_form"><i
                                                            class="fa fa-plus"></i> Thêm
                                                </a>
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php if(count($data)): ?>
                                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="text-center"><?php echo e($key+1); ?></td>
                                                    <td class="text-center">
                                                        <?php echo e($item->department_id==\App\Constants\DepartmentConstant::SALE?'Sale'
                                                        :($item->department_id==\App\Constants\DepartmentConstant::MARKETING?'Marketing'
                                                        :($item->department_id==\App\Constants\DepartmentConstant::CSKH?'CSKH':''))); ?>

                                                    </td>
                                                    <td class="text-center"><?php echo e($item->code); ?></td>
                                                    <td class="text-center"><?php echo e($item->name); ?></td>
                                                    <td class="text-center"><?php echo e($item->user->name); ?></td>
                                                    <td class="text-center"><?php echo e($item->getNameUser()); ?></td>
                                                    <td class="text-center"><?php echo e($item->created_at); ?></td>
                                                    <td class="text-center">
                                                        <a class="action-control edit" href="javascript:void(0)"
                                                           data-team="<?php echo e($item); ?>"
                                                           data-member="<?php echo e(json_encode($item->arrayIdTeamMember())); ?>">
                                                            <i class="fa fa-edit fa-2x"></i>
                                                        </a>
                                                        <a class="action-control delete" href="javascript:void(0)"
                                                           data-id="<?php echo e($item->id); ?>">
                                                            <i class="fa fa-trash fa-2x"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="9"></td>
                                            </tr>
                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="mt-2">
                                    <?php echo e($data->links()); ?>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>
        <!-- // card-actions section end -->
        <div class="modal fade text-left" id="add_new_form" tabindex="-1" role="dialog" aria-labelledby="myModalLabel35"
             style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header bg-main">
                        <h3 class="modal-title" id="myModalLabel35"> Thêm mới thông tin đội, nhóm</h3>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <?php echo $__env->make('backend.system.team._form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>


    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php echo $__env->make('backend.layouts.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        var department_sale = 3;
        var department_mkt = 4;
        var department_cskh = 5;

        $(document).ready(function () {
            $("#leader_id,#user_id").select2({
                dropdownParent: $("#add_new_form"),
                placeholder: 'Chọn',
                width: '100%',
                allowClear: true
            });
        })

        $("#team-my-form").validate({
            rules: {
                department_id: "required",
                code: "required",
                name: "required",
                leader_id: "required"
            },
        })

        //add team
        $(document).on('click', '#add_new', async function () {
            resetValue();
            await getLeaderTeam();
            $('#add_new_form').modal({show: true})
        })

        // edit
        $(document).on('click', '.edit', async function () {
            let team = $(this).data('team');
            await getLeaderTeamEdit(department_sale,team.id);
            let teamMember = $(this).data('member');
            teamMember = teamMember.map(m => m.toString());
            let form = $('#team-my-form');
            form.attr('action', '/system/teams/' + team.id);
            form.attr('method', 'POST');
            $('#myModalLabel35').html('Cập nhật thông tin đội, nhóm').change();
            form.append('<input name="_method" type="hidden" value="PUT" />');

            $('#department_id').val(team.department_id);
            $('#code').val(team.code);
            $('#name').val(team.name);
            $('#leader_id').val(team.leader_id.toString()).trigger('change');
            $('#user_id').val(teamMember).change();
            $('#add_new_form').modal({show: true})

        });

        // Chọn kiểu nhóm
        $('#department_id').on('select2:select', function (e) {
            // console.log(123123,e.target.value);
            getLeaderTeam(e.target.value);
        });

        async function getLeaderTeam(department_id = department_sale) {
            let html = '';
            let row = $('body').find('#leader_id');
            let row1 = $('body').find('#user_id');
            await $.ajax({
                url: '/ajax/get-all-user-department-not-team',
                data:{
                    department: department_id
                },
                success: function (data) {
                    if (data.user && data.user.length > 0) {
                        let user = data.user;
                        user.forEach(element => {
                            html += `
                                <option value='` + element.id + `'>` + element.name + `</option>
                            `
                            row.html(html);
                            row1.html(html);
                        });
                    } else {
                        row.html(html);
                        row1.html(html);
                    }
                }
            })
        }

        //get nhân viên sale chưa có team và nhân viên sale có trong team đang chọn
        async function getLeaderTeamEdit(department_id,team_id) {
            let html = '';
            let row = $('body').find('#leader_id');
            let row1 = $('body').find('#user_id');
            await $.ajax({
                url: '/ajax/get-all-user-department-team',
                data:{
                    department: department_id,
                    team_id: team_id
                },
                success: function (data) {
                    if (data.user && data.user.length > 0) {
                        let user = data.user;
                        user.forEach(element => {
                            html += `
                                <option value='` + element.id + `'>` + element.name + `</option>
                            `
                            row.html(html);
                            row1.html(html);
                        });
                    } else {
                        row.html(html);
                        row1.html(html);
                    }
                }
            })
        }
        
        function resetValue() {
            $('#department_id').val(department_sale);
            $('#code').val('');
            $('#name').val('');
            $('#leader_id').val({}).change();
            $('#user_id').val([]).change();

        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cms-tmdt-adam/resources/views/backend/system/team/index.blade.php ENDPATH**/ ?>