const app = require("./app");
var controller = require('./controllers/TiviBoxController');
const https = require("https");
// const http = require("http");
const port = process.env.PORT || 2022;
const privkeys = process.env.privkey || '/etc/letsencrypt/live/thuongmai.adamtech.vn/privkey.pem';
const certs = process.env.cert || '/etc/letsencrypt/live/thuongmai.adamtech.vn/cert.pem';
const chains = process.env.chain || '/etc/letsencrypt/live/thuongmai.adamtech.vn/chain.pem';

const fs = require('fs');
const key = fs.readFileSync(privkeys);
const cert = fs.readFileSync(certs);
const ca = fs.readFileSync(chains);
const options = {
    key: key,
    cert: cert,
    ca: ca
};
const server = https.createServer(options, app);
// const server = http.createServer(app);
const model = require("./models/TiviBox");
var io = require('socket.io')(server);

app.use(function (req, res, next) {
    req.io = io;
    next();
});

io.on("connect_error", (err) => {
    console.log(`connect_error due to ${err.message}`);
});
// io.on('connection', function (client) {
//
//     client.on('disconnect', function () {
//         const socket_id = client.id;
//         console.log('disconnect devices');
//     });
// });

app.get('/', (req, res) => {
    res.send("Home page. Server running okay.");
});

app.get('/webhook', function (req, res) {
    if (req.query['hub.verify_token'] === '0975091435') {
        res.send(req.query['hub.challenge']);
    }
    res.send('Error, wrong validation token');
});

app.post('/webhook', function (req, res) {
    var entries = req.body.entry;
    res.sendStatus(200);
    for (var entry of entries) {
        var messaging = entry.messaging;
        if (messaging) {
            for (var message of messaging) {
                console.log(message, 'Message');
                var senderId = message.sender.id;
                var recipientId = message.recipient.id;
                if (message.message) {
                    controller.sendSocketMessages(message, io);
                    if (message.message.text) {
                        let text = message.message.text;
                        text = text.replace(".", "");
                        text = text.replace("O", "0");
                        console.log('Noi dung tin nhan', text); // In tin nhắn người dùng
                        let letr = text.match(/\d+/g);
                        if (!letr) {
                            return false;
                        }
                        letr.every(function (i) {
                            if (i.length === 10) {
                                controller.SetCustomers(i, recipientId, message.message.text, senderId);
                                return false;
                            }
                        })
                    }
                }
            }
        } else {

            var comments = entry.changes;
            for (var value of comments) {
                if (value.value.item === 'comment') {
                    let text2 = value.value.message;
                    text2 = text2.replace(".", "");
                    text2 = text2.replace("O", "0");
                    let letr = text2.match(/\d+/g);
                    if (!letr) {
                        return false;
                    }
                    letr.every(function (i) {
                        if (i.length === 10) {
                            controller.SetComment(i, value.value.post_id, value.value.message, value.value.from.name);
                            return false;
                        }
                    })
                }
            }
        }
    }
});

server.listen(port, "0.0.0.0", function (error) {
    if (error) console.log("Connect error");
    // const created_at = new Date();
    // io.connect("/");
    console.log("Start server port:", port, io.connected);
});

