<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('test', function () {
    return view('test');
});
Route::get('privacy-policy', function () {
    return view('policy');
});
Route::get('form/{id}', 'Backend\Marketing\SourceController@getForm');
Route::post('client-data/{id}', 'Backend\CustomerController@clientData');

Auth::routes();
//Route::post('/logout','Auth\LoginController@logout');

Route::get('/', 'HomeController@index')->name('home')->middleware('auth');

Route::group(['middleware' => 'auth'], function () {
    //Login Facebook
    Route::get('login/facebook', 'HomeController@postLoginFB')->name('facebook.login');
    Route::get('login/facebook/callback', 'HomeController@callbackFB');
    Route::get('remove-account-facebook', 'HomeController@removeAccount')->name('facebook.removeAccount');
});

Route::group(['namespace' => 'Backend', 'middleware' => 'auth'], function () {

    Route::get('user-profile', 'UserController@profile');
    Route::post('user-profile', 'UserController@updateProfile');

    Route::resource('san-pham', 'ProductController');
    Route::post('import-product', 'ProductController@import')->name('product.import');
    Route::post('import-history-depot', 'HistoryDepotController@import')->name('history_depot.import');

    Route::group(['prefix' => 'depots', 'as' => 'depots.'], function () {
        Route::resource('product', 'ProductDepotController');
        Route::resource('history', 'HistoryDepotController');
        Route::resource('list', 'DepotController');
    });

    Route::group(['namespace' => 'Product', 'prefix' => 'product', 'as' => 'product.'], function () {
        Route::resource('category', 'CategoryController');
    });

    Route::group(['prefix' => 'marketing', 'as' => 'marketing.'], function () {
        Route::resource('fanpage', 'FanpageController');
        Route::get('unsubscribeb-fanpage', 'FanpageController@unsubscibedFanpage');

        Route::get('ranking', 'Marketing\RankingController@marketing')->name('marketing.ranking');
        Route::resource('fanpage-post', 'FanpagePostController');
        Route::post('storePost', 'FanpagePostController@storeCustom')->name('fanpage_post.storeCustom');
        Route::resource('seeding-number', 'SeedingNumberController');
        Route::resource('custom-data', 'InsertDataCustomController');
        Route::resource('thong-ke-truong-nhom', 'Marketing\LeaderController');
        Route::get('thong-ke-team-sale', 'Marketing\LeaderController@teamSale');
        Route::get('bao-cao-doanh-so', 'Marketing\LeaderController@doanhSoCity');
    });

    Route::group(['namespace' => 'Sale', 'prefix' => 'sale', 'as' => 'sale.'], function () {
        Route::resource('customer', 'CustomerController');
        Route::post('import-data-customers', 'CustomerController@importExcelCustomers');
        Route::get('depot-number-float', 'CustomerController@depotNumber')->name('depotNumber');
        Route::resource('operation', 'SaleController');
        Route::get('report', 'SaleController@report')->name('report');
        Route::get('optimal', 'SaleController@optimal');
        Route::get('ranking', 'RankingController@sale')->name('ranking');
        Route::get('thong-ke-ty-le-chot-don', 'SaleController@statisticalCloseOrder')->name('statisticalCloseOrder');
        Route::get('thong-ke-truong-nhom-sale', 'SaleController@statisticalTeamSale')->name('statisticalTeamSale');

        Route::get('thong-ke-team-sale', 'SaleController@statisticalListTeamSale')->name('statisticalListTeamSale');
    });

    Route::group(['namespace' => 'Marketing', 'prefix' => 'marketing', 'as' => 'marketing.'], function () {
        Route::get('chat-messagers/{page_id}', 'ChatController@index');
        Route::resource('source', 'SourceController');
        Route::get('dashboard', 'DashboardController@index');
    });

    Route::group(['namespace' => 'System', 'prefix' => 'system', 'as' => 'system.'], function () {
        Route::resource('teams', 'TeamController');
        Route::resource('users', 'UserController');
        Route::get('shield/setting-password', 'UserController@settingPassword');
        Route::post('update-password-default', 'UserController@updatePasswordDefault');
        Route::resource('operation', 'OperationController');
        Route::resource('setting-operation', 'SettingOperationController');
        Route::get('history-login', 'UserController@historyLogin');
        Route::get('history-export-import', 'UserController@historyExport');
    });

    Route::group(['namespace' => 'Order'], function () {
        Route::resource('order', 'OrderController');
        Route::put('update-status-order/{orderId}', 'OrderController@updateStatusOrder');
        Route::get('get-order-phoneNumber/{phoneNumber}', 'OrderController@getOrder');
        Route::get('get-order/{orderId}','OrderController@getOrderId');
        Route::get('update-order-depot','OrderController@updateOrderDepot');
    });

    Route::group(['namespace' => 'Accounting', 'prefix' => 'accounting', 'as' => 'accounting.'], function () {
        Route::resource('doi-soat', 'DoiSoatController');
    });

    Route::group(['namespace' => 'Depot', 'prefix' => 'depot', 'as' => 'depot.'], function () {
        Route::get('depot-tac-nghiep', 'DangDonController@index');
        Route::get('export-order', 'OrderController@exportExcel');
        Route::get('export-order1', 'DangDonController@exportExcel');
        Route::put('update-status-order', 'DangDonController@updateOrder');
        Route::put('update-status-order/list-code', 'DangDonController@updateOrderListCode');
        Route::put('update-order/hoa-hong', 'DangDonController@updateOrderHoaHong');


        Route::get('ton-kho','DangDonController@tonKho');
    });

    Route::group(['namespace' => 'Statistical', 'prefix' => 'statistical', 'as' => 'statistical.'], function () {
        Route::get('phong-than-bang', 'StatisticalController@phongThan')->name('phong-than-bang');
        Route::get('bao-cao-kho', 'StatisticalController@depot')->name('depots');
        Route::resource('marketing', 'MarketingController');
        Route::resource('sale', 'SaleController');
        Route::get('bao-cao-doanh-thu', 'StatisticalController@baoCaoDoanhThu')->name('bao-cao-doanh-thu');
        Route::get('thong-ke-sale', 'StatisticalController@saleCustomerProduct');

    });

    /*
  |--------------------------------------------------------------------------
  | CMS for AJAX
  |--------------------------------------------------------------------------
  */
    Route::group(['prefix' => 'ajax'], function () {
        Route::get('searchLocation', 'LocationController@searchAllLocation');
        Route::get('searchDistrict/{city}', 'LocationController@searchAllDistrict');
        Route::get('searchWards/{district}', 'LocationController@searchAllWards');
        Route::get('searchAllUseWards/{ward}', 'LocationController@searchAllUseWards');
        Route::get('location/cac-tinh-mien-bac', 'LocationController@locationMienBac');
        Route::get('location/cac-tinh-mien-trung', 'LocationController@locationMienTrung');
        Route::get('location/cac-tinh-mien-nam', 'LocationController@locationMienNam');

        Route::get('showDepot/{id}', 'DepotController@showDepot');
        Route::post('create-history', 'System\UserController@ajaxCreateHistory');

        Route::get('get-all-user-department', 'System\UserController@getAllUserDepartment');
        Route::get('get-all-user-department-not-team', 'System\UserController@getAllUserDepartmentNotTeam');
        Route::get('get-all-user-department-team', 'System\UserController@getAllUserDepartmentTeam');

        Route::get('get-all-product-depot', 'ProductDepotController@getAll');
        Route::get('product-deport/{deport_id}', 'ProductDepotController@getDetail');

        Route::put('customer/change-status', 'CustomerController@changeStatus');
        Route::get('customer/history-status', 'CustomerController@historyStatus');
        Route::get('customer/history-operation-depot', 'CustomerController@historyOperationDepot');
        Route::get('get-sale-message/{customer_id}', 'CustomerController@getMessage');
        Route::post('send-message', 'CustomerController@sendMessage');
        Route::put('sale-note', 'CustomerController@saleNote');
        Route::put('sale-note-custom', 'CustomerController@saleNoteCustom');
        Route::post('save-message', 'CustomerController@saveMessage');

        Route::put('update-category-position', 'Product\CategoryController@updatePosition');

        Route::get('get-token-fanpage/{id}', 'Marketing\ChatController@getFanpageToken');

        Route::get('get-current-user', 'UserController@ajaxGetUser');
        Route::delete('delete-seeding', 'SeedingNumberController@deleteSeeding');

        Route::post('user-filter-grid', 'UserController@userFilterGrid');


        Route::group(['namespace' => 'Order', 'prefix' => 'order', 'as' => 'order.'], function () {
            Route::get('searchOrder', 'OrderController@searchOrder');
            Route::put('sale-huy-don', 'OrderController@saleHuyDon');
        });

        Route::group(['namespace' => 'Sale', 'prefix' => 'sale', 'as' => 'sale.'], function () {
            Route::get('getOrderDetail/{customer_id}', 'SaleController@getOrderDetail');
            Route::put('phan-bo-data', 'SaleController@phanBoData');
            Route::put('phan-bo-source', 'CustomerController@phanBoSource');
            Route::get('job-schedule', 'SaleController@getJobSchedule');
            Route::post('save-job-schedule', 'SaleController@saveJobSchedule');
            Route::post('update-job-schedule', 'SaleController@updateJobSchedule');
            Route::get('total-job-schedule-new', 'SaleController@totalJobScheduleNew');

            Route::get('search-phone-customer', 'SaleController@searchPhoneCustomer');

        });
        Route::group(['namespace' => 'Marketing', 'prefix' => 'marketing', 'as' => 'marketing.'], function () {
            Route::post('addLanding', 'DashboardController@addLanding');
            Route::get('get-price-marketing', 'DashboardController@getPriceMarketing');
            Route::post('update-price-marketing', 'DashboardController@updatePriceMarketing');
            Route::post('add-line-price-marketing', 'DashboardController@addLinePriceMarketing');
            Route::delete('delete-price-marketing/{id}', 'DashboardController@deleteLinePriceMarketing');

            Route::get('get-all-source', 'SourceController@getAllSource');
            Route::post('update-accept-source', 'SourceController@updateAcceptSource');

            Route::get('sale-get-source', 'SourceController@saleGetSource');

        });

        Route::group(['namespace' => 'Depot', 'prefix' => 'depot', 'as' => 'depot.'], function () {
            Route::post('update-status-giao-hang', 'DangDonController@updateStatusGiaoHang');
            Route::post('update-warehouse', 'DangDonController@phanBoDonKho');
            Route::put('update-note', 'DangDonController@updateNote');
        });


        Route::group(['namespace' => 'System', 'prefix' => 'system', 'as' => 'system.'], function () {
            Route::post('create-customer-status', 'OperationController@createCustomerStatus');
            Route::put('update-customer-status/{id}', 'OperationController@updateCustomerStatus');
            Route::delete('delete-customer-status/{id}', 'OperationController@deleteCustomerStatus');
            Route::put('update-customer-position', 'OperationController@updateCustomerPosition');
            Route::put('update-color-customer-status', 'OperationController@updateColorCustomerStatus');

            Route::post('create-order-status', 'OperationController@createOrderStatus');
            Route::put('update-order-status/{id}', 'OperationController@updateCustomerAction');
            Route::delete('delete-order-status/{id}', 'OperationController@deleteOrderStatus');
            Route::put('update-order-position', 'OperationController@updateOrderPosition');

            Route::post('create-customer-time', 'OperationController@createCustomerTime');
            Route::put('update-customer-time/{id}', 'OperationController@updateCustomerTime');
            Route::delete('delete-customer-time/{id}', 'OperationController@deleteCustomerTime');

            Route::resource('setting-operation', 'SettingOperationController');
            
            Route::post('reset-login','UserController@resetLogin');
        });
    });
});
