<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});


Route::group(['namespace' => 'APIs'], function () {
    Route::resource('source', 'SourceController');
    Route::get('get-all-marketing', 'SourceController@getAllMarketing');
    Route::get('get-all-product-source', 'SourceController@getAllProductSource');
    Route::post('update-accept-source', 'SourceController@updateAcceptSource');
    Route::post('update-setting-source', 'SourceController@updateSettingSource');
    Route::post('Contact/ReceiveData/sc/{id}', 'SourceController@storeCustomerLandipage');
});
