<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="">
    <title>Laravel</title>

    <link rel="stylesheet" type="text/css" href="{{asset('backend/app-assets/css/vendors.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('backend/css/style.css')}}">
    <script src="{{asset('backend/app-assets/js/core/libraries/jquery.min.js')}}"></script>
    <!-- Alertify -->
    <link href="/backend/plugins/alertify/alertify.min.css" rel="stylesheet" type="text/css">
    <script src="/backend/plugins/alertify/alertify.min.js"></script>
</head>
<body style="overflow: hidden">

<div class="">
    @if(isset($source->form_html))
        {!! $source->form_html !!}
    @endif
</div>
<script crossorigin="*">
    $(document).on('click', '.btn.form-control', function () {

        var $form = $("#postForm");
        if ($form.valid()){
            let id = {{$source->id}};
            let form = $('form');
            let full_name = form.find("input[name='full_name']").val();
            let phone = form.find("input[name='phone']").val();
            let email = form.find("input[name='email']").val();
            let textarea = form.find("textarea[name='content']").val();
            let button = $(this);
            $.ajax({
                url: location.origin + '/client-data/' + id,
                method: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    name: full_name,
                    email: email,
                    phone: phone,
                    message: textarea
                },
                success: function (data) {
                    button.attr('disabled', true);
                    if (button.prop('tagName').toLowerCase() === 'input') {
                        button.val('Đăng ký thành công');
                    } else {
                        button.text('Đăng ký thành công');
                        alertify.success(data);
                    }
                }
            })
        } else {
            return;
        }

    })

    alertify.defaults = {
        // dialogs defaults
        autoReset: true,
        basic: false,
        closable: true,
        closableByDimmer: true,
        invokeOnCloseOff: false,
        frameless: false,
        defaultFocusOff: false,
        maintainFocus: true, // <== global default not per instance, applies to all dialogs
        maximizable: true,
        modal: true,
        movable: true,
        moveBounded: false,
        overflow: true,
        padding: true,
        pinnable: true,
        pinned: true,
        preventBodyShift: false, // <== global default not per instance, applies to all dialogs
        resizable: true,
        startMaximized: false,
        transition: 'fade',
        transitionOff: false,
        tabbable: 'button:not(:disabled):not(.ajs-reset),[href]:not(:disabled):not(.ajs-reset),input:not(:disabled):not(.ajs-reset),select:not(:disabled):not(.ajs-reset),textarea:not(:disabled):not(.ajs-reset),[tabindex]:not([tabindex^="-"]):not(:disabled):not(.ajs-reset)',  // <== global default not per instance, applies to all dialogs

        // notifier defaults
        notifier: {
            // auto-dismiss wait time (in seconds)
            delay: 3,
            // default position
            position: 'bottom-right',
            // adds a close button to notifier messages
            closeButton: false,
            // provides the ability to rename notifier classes
            classes: {
                base: 'alertify-notifier',
                prefix: 'ajs-',
                message: 'ajs-message',
                top: 'ajs-top',
                right: 'ajs-right',
                bottom: 'ajs-bottom',
                left: 'ajs-left',
                center: 'ajs-center',
                visible: 'ajs-visible',
                hidden: 'ajs-hidden',
                close: 'ajs-close'
            }
        },

        // language resources
        glossary: {
            // dialogs default title
            title: 'AlertifyJS',
            // ok button text
            ok: 'OK',
            // cancel button text
            cancel: 'Cancel'
        },

        // theme settings
        theme: {
            // class name attached to prompt dialog input textbox.
            input: 'ajs-input',
            // class name attached to ok button
            ok: 'ajs-ok',
            // class name attached to cancel button
            cancel: 'ajs-cancel'
        },
        // global hooks
        hooks: {
            // invoked before initializing any dialog
            preinit: function (instance) { },
            // invoked after initializing any dialog
            postinit: function (instance) { },
        },
    };
    alertify.set('notifier','position', 'top-right');
</script>
{{--Validate--}}
<script src="/backend/plugins/validate/jquery.validate.min.js"></script>
<script>
    $().ready(function () {
        $("#postForm").validate({
            onsubmit: true,
            rules: {
                full_name: {
                    required: true
                },
                email: {
                    required: true,
                    email: true
                },
                phone: {
                    required: true,
                    minlength: 10,
                    number: true
                }
            },
            messages: {
                full_name: {
                    required: "Vui lòng nhập họ tên"
                },
                email: {
                    required: "Vui lòng nhập email",
                    email: "Email chưa đúng định dạng"
                },
                phone: {
                    required: "Vui lòng nhập số điện thoại",
                    minlength: "Vui lòng nhập lớn hơn 10 ký tự",
                }
            }
        });
    })
</script>
</body>
</html>
