@extends('backend.layouts.master')
@section('content')
    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}
                        <div class="card-header fix-header bottom-card add-paginate">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">10.1 Danh sách nhân viên (TK: {{$docs->total()}})</h4>
                                <div class="col-lg-2 col-md-6">
                                    {!! Form::select('department_id', $role, null, array('id'=>'department_id','class' => 'form-control square','placeholder'=>'--Chức vụ--')) !!}
                                </div>
                                <div class="col-lg-2 col-md-6">
                                    {!! Form::select('is_leader', $isLeader, null, array('id'=>'is_leader','class' => 'form-control square ','placeholder'=>'--Chọn trưởng nhóm--')) !!}
                                </div>

                                <div class="col-lg-2 col-md-6">
                                    <select name="pc_name" id="" class="form-control">
                                        <option value="">Tất cả</option>
                                        <option value="1">Đăng nhập 1 nơi</option>
                                        <option value="2">Đăng nhập nhiều nơi</option>
                                    </select>
                                </div>

                                <div class="col-lg-2 col-md-6">
                                    <input name="name" type="text" class="form-control square"
                                           placeholder="Tìm kiếm tên ...">
                                </div>
                                <button type="submit" class="btn btn-primary searchData" id="btnSearch"><i
                                        class="fa fa-search"></i> Tìm kiếm
                                </button>
                            </div>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        {{ Form::close() }}
                        <div class="card-content collapse show">
                            <div class="card-body">
                                @include('backend.system.users.ajax')
                                @include('backend.system.users._form')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- // card-actions section end -->
    </div>
@endsection
@section('script')
    @include('backend.layouts.script')
    <script>

        $('#department_id,#is_leader').on('change', function () {
            $('#gridForm').submit();
        })
        $('body').delegate('.save', 'click', function () {
            let id = $(this).data('id');
            let phone = $(this).closest('tr').find('.phone').val();
            let email = $(this).closest('tr').find('.email').val();
            let leader = $(this).closest('tr').find('.leader').is(":checked") == true ? 1 : 0;
            let doi_soat = $(this).closest('tr').find('.doi-soat-kho').is(":checked") == true ? 1 : 0;
            let status = $(this).closest('tr').find('.status').is(":checked") == true ? 0 : 1;
            console.log(doi_soat, 'DOI SOAT');

            let patt1 = /^[0-9]*$/g;
            let result = phone.match(patt1);

            if (result == null) {
                alertify.warning('Số điện thoại không đúng định dạng');
                return;
            }

            $.ajax({
                type: "PUT",
                url: location.href + '/' + id,
                data: {phone: phone, email: email, is_leader: leader, status: status, doi_soat: doi_soat},
                success: function () {
                    location.reload()
                }
            });
        })

        $('body').delegate('.password', 'click', function () {
            let id = $(this).data('id');
            let form = $('.update-pass');
            form.attr('action', location.href + '/' + id);
            form.attr('method', 'POST');
            $('.value-form').append('<input name="_method" type="hidden" value="PUT">');
            $('#change_password').modal('show');

        })
        $('.modal-body').delegate('#phone', 'change', function () {
            let target = $(this).val();
            $.ajax({
                url: "{{ url('api/check-unique-customers') }}",
                method: "get",
                data: {phone: target}
            }).done(function (data) {
                if (data == 'true') {
                    $('#phone-error').css("display", "block");
                    $('#phone-error').html('Số điện thoại đã tồn tại trong hệ thống');
                } else {
                    $('#phone-error').html('').change();
                    $('#phone-error').css("display", "none");
                }
            });
        });
        $('.modal-body').delegate('#email', 'change', function () {
            let target = $(this).val();
            $.ajax({
                url: "{{ url('api/check-unique-customers') }}",
                method: "get",
                data: {email: target}
            }).done(function (data) {
                if (data == 'true') {
                    $('#email-error').css("display", "block");
                    $('#email-error').html('Email đã tồn tại trong hệ thống');
                } else {
                    $('#email-error').html('').change();
                    $('#email-error').css("display", "none");
                }
            });
        });
        $().ready(function () {
            $("#validateForm").validate({
                rules: {
                    name: 'required',
                    department_id: 'required',
                },
                messages: {
                    name: "Vui lòng nhập tên !",
                    department_id: "Vui lòng chọn chức vụ !",
                }
            })

        });
        $('.btn-password').on('click', function () {
            let pass = $('#password').val();
            let confirm = $('#confirm_password').val();
            if (!pass) {
                alertify.warning('Vui lòng nhập mật khẩu !');
                return;
            } else if (pass == confirm) {
                $('.update-pass').submit();
            } else {
                alertify.warning('Mật khẩu và xác thực chưa trùng nhau !');
            }
        })
        $(document).on('change','#type_login',function(){
            let value = $(this).val();
            let id = $(this).data('id');
            $.ajax({
                url:'/ajax/system/reset-login',
                method:'POST',
                data:{
                    id:id,
                    type:value
                },
                success:function(data){
                    if(data){
                        alertify.success('Cập nhật thành công !');
                    }
                }
            })
        })
    </script>
@endsection
