@extends('backend.layouts.master')
@section('content')
    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}

                        <div class="card-header fix-header bottom-card">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">10.2 Quản lý đội, nhóm</h4>
                                <div class="col-lg-3 col-md-6">
                                    <input name="name" type="text" class="form-control square" placeholder="Tên nhóm">
                                </div>
                                <button class="btn btn-primary searchData"><i class="fa fa-search"></i> Tìm kiếm</button>
                            </div>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        {!! Form::close() !!}
                        <div class="card-header fix-header"></div>
                        <div class="card-content collapse show">
                            <div class="card-body">
                                @include('backend.system.team.ajax')
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>
        <!-- // card-actions section end -->
        <div class="modal fade text-left" id="add_new_form" tabindex="-1" role="dialog" aria-labelledby="myModalLabel35"
             style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header bg-main">
                        <h3 class="modal-title" id="myModalLabel35"> Thêm mới thông tin đội, nhóm</h3>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    @include('backend.system.team._form')
                </div>
            </div>
        </div>


    </div>
@endsection
@section('script')
    @include('backend.layouts.script')
    <script>

        let department_sale = 3;
        $(document).ready(function () {
            $("#leader_id,#user_id").select2({
                dropdownParent: $("#add_new_form"),
                placeholder: 'Chọn',
                width: '100%',
                allowClear: true
            });
        })

        $("#team-my-form").validate({
            rules: {
                department_id: "required",
                code: "required",
                name: "required",
                leader_id: "required"
            },
        })

        //add team
        $(document).on('click', '#add_new', async function () {
            resetValue();
            await getLeaderTeam();
            $('#add_new_form').modal({show: true})
        })

        // edit
        $(document).on('click', '.edit', async function () {
            let team = $(this).data('team');
            await getLeaderTeamEdit(team.department_id,team.id);
            let teamMember = $(this).data('member');
            teamMember = teamMember.map(m => m.toString());
            let form = $('#team-my-form');
            form.attr('action', '/system/teams/' + team.id);
            form.attr('method', 'POST');
            $('#myModalLabel35').html('Cập nhật thông tin đội, nhóm').change();
            form.append('<input name="_method" type="hidden" value="PUT" class="_method" />');

            $('#department_id').val(team.department_id).change();
            $('#code').val(team.code);
            $('#name').val(team.name);
            $('#depot_id').val(team.depot_id).trigger('change');
            $('#cskh_id').val(team.cskh_id).trigger('change');
            $('#leader_id').val(team.leader_id.toString()).trigger('change');
            $('#user_id').val(teamMember).change();
            $('#add_new_form').modal({show: true})

        });

        // Chọn kiểu nhóm
        $('#department_id').on('select2:select', function (e) {
            getLeaderTeam(e.target.value);
        });

        async function getLeaderTeam(department_id = department_sale) {
            let html = '';
            let row = $('body').find('#leader_id');
            let row1 = $('body').find('#user_id');
            await $.ajax({
                url: '/ajax/get-all-user-department-not-team',
                data:{
                    department: department_id
                },
                success: function (data) {
                    if (data.user && data.user.length > 0) {
                        let user = data.user;
                        user.forEach(element => {
                            html += `
                                <option value='` + element.id + `'>` + element.name + `</option>
                            `
                            row.html(html);
                            row1.html(html);
                        });
                    } else {
                        row.html(html);
                        row1.html(html);
                    }
                }
            })
        }

        //get nhân viên chưa có team và nhân viên có trong team đang chọn
        async function getLeaderTeamEdit(department_id,team_id) {
            let html = '';
            let row = $('body').find('#leader_id');
            let row1 = $('body').find('#user_id');
            await $.ajax({
                url: '/ajax/get-all-user-department-team',
                data:{
                    department: department_id,
                    team_id: team_id
                },
                success: function (data) {
                    if (data.user && data.user.length > 0) {
                        let user = data.user;
                        user.forEach(element => {
                            html += `
                                <option value='` + element.id + `'>` + element.name + `</option>
                            `
                            row.html(html);
                            row1.html(html);
                        });
                    } else {
                        row.html(html);
                        row1.html(html);
                    }
                }
            })
        }
        
        function resetValue() {
            let form = $('#team-my-form');
            form.attr('action', '/system/teams');
            $('._method').remove();
            $('#department_id').val(department_sale).change();
            $('#code').val('');
            $('#name').val('');
            $('#leader_id').val({}).change();
            $('#depot_id').val({}).change();
            $('#user_id').val([]).change();
        }
    </script>
@endsection
