<div class="table-responsive tableFixHead table-bordered table-hover">
    <table class="table table-custom table-striped">
        <thead>
        <tr>
            <th class="text-center">STT</th>
            <th class="text-center">Địa chỉ IP</th>
            <th class="text-center">Loại</th>
            <th class="text-center">Nội dung tải</th>
            <th class="text-center">Thực hiện</th>
            <th class="text-center">Thời gian thực hiện</th>
        </tr>
        </thead>
        <tbody>
        @if(count($histories))
            @foreach($histories as $k => $item)
                <tr>
                    <td class="text-center">{{$k+1}}</td>
                    <td class="text-center">{{$item->ip_address}}</td>
                    <td class="text-center">{{$item->type == 0 ? 'Upload' : 'Tải xuống'}}</td>
                    <td class="text-center">
                    @if($item->data == \App\Constants\HistoryConstant::DATA_PRODUCT)
                        Sản phẩm
                    @elseif($item->data == \App\Constants\HistoryConstant::DATA_CUSTOMER)
                        DS khách hàng (4.3)
                    @elseif($item->data == \App\Constants\HistoryConstant::DATA_DEPOT)
                        DS đơn hàng kho (6.1)
                    @elseif($item->data == \App\Constants\HistoryConstant::DATA_ACCOUNTING)
                        DS đơn hàng đối soát (8.1)
                    @elseif($item->data == \App\Constants\HistoryConstant::BAO_CAO_MKT)
                        Báo cáo nhóm MKT (3.1)
                    @elseif($item->data == \App\Constants\HistoryConstant::BAO_CAO_SALE)
                        Báo cáo nhóm Sale (5.2)
                    @elseif($item->data == \App\Constants\HistoryConstant::BAO_CAO_KHO)
                        Báo cáo doanh thu kho (9.3)
                    @elseif($item->data == \App\Constants\HistoryConstant::BAO_CAO_MKT_9)
                        Báo cáo doanh thu MKT (9.1)
                    @elseif($item->data == \App\Constants\HistoryConstant::BAO_CAO_SALE_9)
                        Báo cáo doanh thu SALE (9.2)
                    @endif
                    </td>
                    <td class="text-center">{{@$item->user->name}} <span class="small-tip">({{@$item->user->username}})</span></td>
                    <td class="text-center">{{$item->created_at}}</td>
                </tr>
            @endforeach
        @else
            <tr>
                <td class="text-center" colspan="7">Không có dữ liệu</td>
            </tr>
        @endif
        </tbody>
    </table>
    <div class="mt-2 float-right">
        <select id="customPage" style="height: 33px !important;">
            <option value="20" {{isset($paginate) && $paginate == 20 ? 'selected' : ''}}>20</option>
            <option value="50" {{isset($paginate) && $paginate == 50 ? 'selected' : ''}}>50</option>
            <option value="100" {{isset($paginate) && $paginate == 100 ? 'selected' : ''}}>100</option>
        </select> <span>Số bản ghi</span>
        {{$histories->links()}}
    </div>
</div>

