@extends('backend.layouts.master')
@section('content')
    <div class="content-body statistical-mkt">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}
                        <div class="card-header fix-header bottom-card">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-4">9.1 Báo cáo doanh số Marketing</h4>
                                <input type="hidden" name="start_date" id="start_date">
                                <input type="hidden" name="end_date" id="end_date">
                                <div class="col-lg-3 col-md-6">
                                    <input id="reportrange" type="text" class="form-control square"></div>
                                <div class="col-lg-3 mb-1">
                                    <div class="form-group">
                                        <select class="form-control square select2" name="product_id" data-placeholder="--Tất cả sản phẩm--">
                                            <option></option>
                                            @if(count($products))
                                                @foreach($products as $k =>$item)
                                                    <option value="{{$k}}">{{$item}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary" id="btnSearch"><i class="fa fa-search"></i> Tìm kiếm</button>

                                @include('backend.statistical.marketing.dropdownFilter')
                            </div>
                        </div>
                        {{ Form::close() }}
                        <div class="card-content collapse show">
                            <div class="card-body">
                                @include('backend.statistical.marketing.ajax')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>
@endsection
@section('script')
    @include('backend.layouts.script')

    <script type="text/javascript" src="{{asset('js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/daterangepicker.min.js')}}"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('css/daterangepicker.css')}}"/>
    <script type="text/javascript" src="{{asset('js/dateranger-config.js')}}"></script>

@endsection
