@extends('backend.layouts.master')
@section('content')
    <style>
        input.select2-search__field {
            margin-top: 0 !important;
        }

        .modal-header.bg-main {
            height: 35px;
        }

        .modal-header.bg-main .modal-title {
            line-height: 10px;
            font-size: 18px;
        }
    </style>

    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}
                        <div class="card-header fix-header bottom-card">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">Báo cáo doanh thu Kho</h4>
                                <div class="col-lg-3">
                                    <select class="select2 square changeTypeSearch" name="type_search" id="type_search">
                                        <option></option>
                                        <option value="1">1.Kho</option>
                                        <option value="2">2.Sản phẩm</option>
                                        <option value="3">3.Khách cũ/mới</option>
                                    </select>
                                </div>
                                <div class="col-md-2 productId" style="display: none">
                                    <select class="select2 square" name="product_id" id="product_id"
                                            data-placeholder="-- Tất cả sản phẩm--">
                                        <option></option>
                                        @if(isset($products) && count($products))
                                            @foreach($products as $item)
                                                <option value="{{$item->id}}">{{$item->name}}</option>
                                            @endforeach
                                        @endif

                                    </select>
                                </div>
                                <div class="col-lg-3 col-md-6">
                                    <input type="hidden" name="start_date" id="start_date">
                                    <input type="hidden" name="end_date" id="end_date">
                                    <input id="reportrange" type="text" class="form-control square">
                                </div>

                                <button class="btn btn-primary searchData"><i class="fa fa-search"></i> Tìm kiếm
                                </button>
                            </div>

                            @include('backend.statistical.bao_cao_doanh_thu.dropdownFilter')

                        </div>
                        {!! Form::close() !!}
                        <div class="card-header fix-header"></div>

                        <div class="card-content collapse show">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        @include('backend.statistical.bao_cao_doanh_thu.ajax')
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('script')
    @include('backend.layouts.script')
    <script type="text/javascript" src="{{asset('js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/daterangepicker.min.js')}}"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('css/daterangepicker.css')}}"/>
    <script type="text/javascript" src="{{asset('js/dateranger-config.js')}}"></script>
    <script>
        $('.changeTypeSearch').on('select2:select', function (e) {
            let type = e.target.value;
            let type_product = 2;
            if (type == type_product) {
                $('.productId').show()
            } else {
                $('.productId').hide()
            }
        });
    </script>
@endsection
