@extends('backend.layouts.master')
@section('content')
    <style>
        input {
            height: auto !important;
        }

        input.select2-search__field {
            margin-top: 0 !important;
        }

    </style>
    @php
        $is_leader = Auth::user()->is_leader == \App\Constants\DepartmentConstant::IS_LEADER ? true : false;
        $is_teamlead = count(Auth::user()->teams) > 0 ? true : false;
        $is_admin = Auth::user()->department_id == \App\Constants\DepartmentConstant::ADMIN ? true : false;
        $is_ceo = Auth::user()->department_id == \App\Constants\DepartmentConstant::CEO ? true : false;
    @endphp
    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}
                        <div class="card-header fix-header bottom-card">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">5.2 Thống kê trưởng nhóm sale</h4>
                                <div class="col-lg-4 col-md-6">
                                    <input type="hidden" name="start_date" id="start_date">
                                    <input type="hidden" name="end_date" id="end_date">
                                    <input id="reportrange" type="text" class="form-control square">
                                </div>
                                <button class="btn btn-primary"><i class="fa fa-search"></i> Tìm kiếm</button>
                            </div>
                            {{--@if($is_admin || $is_ceo || ($is_sale && $is_leader)))--}}
                            <div class="row mt-1">
                                <div class="col-4">
                                    <select class="select2 square" name="leader_id" id=""
                                            data-placeholder="--Chọn trưởng phòng sale--">
                                        <option></option>
                                        @if($teams instanceof \Illuminate\Database\Eloquent\Collection && count($teams))
                                            @foreach($teams as $item)
                                                <option value="{{$item->id}}">{{@$item->user->name}}
                                                    - {{@$item->user->username}}</option>
                                            @endforeach
                                        @else
                                            <option value=""></option>
                                        @endif

                                    </select>
                                </div>
                                <div class="col-2">
                                    <select class="select2 square" name="type_filter" id=""
                                            data-placeholder="--Kiểu lọc--">
                                        <option></option>
                                        <option value="0">Doanh số tạm tính</option>
                                        <option value="1">Doanh thu tạm tính</option>
                                    </select>
                                </div>
                            </div>
                            {{--@endif--}}
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    @if($is_leader || $is_teamlead||$is_admin || $is_ceo)
                                        <li><a class="excel-html" data-toggle="tooltip" data-placement="right"
                                               title="Tải xuống Excel">
                                                <i class="fa fa-cloud-download" style="color: var(--main-color)"></i></a>
                                        </li>
                                    @endif
                                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        {!! Form::close() !!}
                        <div class="card-header fix-header"></div>

                        <div class="card-content collapse show">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        @include('backend.sale.statistical.ajax_team')
                                        <div class="mt-2">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('script')
    @include('backend.layouts.script')
    <script type="text/javascript" src="{{asset('js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/daterangepicker.min.js')}}"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('css/daterangepicker.css')}}"/>
    <script type="text/javascript" src="{{asset('js/dateranger-config.js')}}"></script>
@endsection
