@extends('backend.layouts.master')

@section('content')
    <style>
        .box-active-1 {
            box-shadow: inset 0 0 4px orange;
        }

        .expired-time td {
            color: red;
        }

        a.tao-don-fixed {
            display: block;
            width: 55px;
            height: 55px;
            background-color: #6ea543;
            border-radius: 50%;
            color: white !important;
            text-align: center;
            padding-top: 9px;
            bottom: 50px;
            position: fixed;
            cursor: pointer;
            z-index: 9999;
            left: 88px;
        }

        .bottom-card {
            border-bottom: 0;
        }

        .tao-don-fixed i {
            font-size: 20px;
        }

        .tao-don-fixed .text {
            font-size: 10px;
            font-weight: bold;
        }

        .table-bordered tr:nth-child(odd) td {
            background-color: #f3f3f3;
        }

        .table-bordered tr:hover td {
            background-color: #deedff;
        }

        /*body{*/
        /*overflow: hidden;*/
        /*}*/

    </style>
    <div class="content-body">
        {{--{{dd($customer_status,$customer_group)}}--}}
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}
                        <div class="card-header fix-header bottom-card add-paginate">
                            <div class="row" style="align-items: baseline">
                                <div class="col-lg-2">
                                    <h4 class="">4.1 Tác nghiệp Sale</h4>
                                </div>
                                <div class="col-lg-4 col-md-6">
                                    <input id="reportrange" type="text" class="form-control square">
                                </div>
                                <div class="col-lg-2 col-md-6">
                                    <select name="sale_id" id="" class="form-control square select2"
                                            data-placeholder="--Tất cả sale--">
                                        <option></option>
                                        @forelse($sale as $key=>$item)
                                            <option value="{{$item->id}}">{{$item->name}} ({{$item->username}})</option>
                                        @empty
                                            <p>No Sale</p>
                                        @endforelse
                                    </select>
                                </div>
                                <input type="hidden" value="" name="customer_status" class="status">
                                <div class="col-lg-2 col-md-6">
                                    <input name="search" type="text" class="form-control square"
                                           placeholder="Nhập SĐT">
                                </div>

                                {{--<div class="col-lg-2 col-md-6">--}}
                                {{--<input name="code" type="text" class="form-control square"--}}
                                {{--placeholder="Mã đơn hàng">--}}
                                {{--</div>--}}
                                <button type="submit" class="btn btn-primary searchData" id="btnSearch"><i
                                        class="fa fa-search"></i> Tìm kiếm
                                </button>
                            </div>
                            @include('backend.sale.operation.dropdownFilter')

                        </div>

                        {{ Form::close() }}
                        <div class="card-content collapse show">
                            <div class="card-body" id="card-body">
                                @include('backend.sale.operation.ajax')
                                @include('backend.sale.operation.modal_order')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        @include('backend.sale.operation.modal_list_order')
        <a class="tao-don-fixed showPopupEdit" href="#">
            <i class="fa fa-edit"></i>
            <div class="text">Tạo đơn</div>
        </a>
        <!-- // card-actions section end -->
    </div>
    @include('components.tin_nhan_noi_bo.modal_internal_message')
    @include('components.lich_su_tac_nghiep.modal_history_operation')
    @include('backend.sale.operation.modal_tao_lich')
@endsection
@section('script')
    @include('backend.layouts.script')

    <script>

        $(document).on('click', '.dm-tac-nghiep', function () {
            // $('.dm-tac-nghiep').removeClass('box-active-1');
            let status = $(this).data('id');
            $('.status').val(status);
            // $(this).addClass('box-active-1');
            $('.searchData').click();
        })
        var form = $('#validateForm');


        $(function () {
            $.ajax({
                url: "/ajax/searchLocation",
                success: function (data) {
                    let html_city = `<option>--Chọn Tỉnh/TP--</option>`
                    data.cities.forEach(element => {
                        html_city += `<option value="` + element.code + `">` + element.name + `</option>`;
                    });
                    $('.city').html(html_city);
                }
            });

        });

        //chọn sản phẩm
        $(document).on('change', '#product_id', function () {
            let id = $(this).val();
            if (!id) return false;
            var text = $(this).find(":selected").text();
            var price = $(this).find(":selected").data('price');
            let price_text = formatNumber(price);
            var html = `<tr>
                <input type="hidden" name="product[]" value="` + id + `">
                <td class="text-center">` + text + `</td>
                <td class="text-center">Còn hàng</td>
                <td class="text-center">
                    <input type="hidden" name="price[]" class="price_value" value="` + price + `">
                    <input readonly type="text" maxlength="5" value="` + price_text + `"
                           class="form-control text-center txt-dotted price"style="height: 23px !important;">
                </td>
                <td class="text-center">
                    <input type="number" maxlength="5" required
                           class="form-control text-center txt-dotted quantity"
                           style="height: 23px !important;" name="quantity[]">
                </td>
                <td class="text-center">
                    <input type="hidden" name="total_item[]" class="total_value">
                    <input readonly type="text" maxlength="5"
                           class="form-control text-center txt-dotted total"
                           style="height: 23px !important;">
                </td>
                <td class="text-center"><a class="delete-item" href="javascript:void(0)"><i class="fa fa-trash"></i></a>
                </td>
            </tr>`;
            $('.list-product').append(html);
        })


        // thay đổi số lượng khi chọn kho
        function changeTotal() {
            let all_quantity = 0;
            let quantity = document.querySelectorAll('.list-product .quantity');

            quantity.forEach(f => {
                all_quantity += parseInt(f.value)
            });

            let all_price = 0;
            let price_ = document.querySelectorAll('.list-product .total');
            price_.forEach(f => {
                all_price += parseInt(replaceNumber(f.value))
            });
            $('.all_price').html(formatNumber(all_price));
            $('.all_quantity').html(all_quantity);

        }


        $(document).on('keyup change', '.quantity', function (e) {
            let all_quantity = 0;
            let quantity = document.querySelectorAll('.list-product .quantity');

            quantity.forEach(f => {
                all_quantity += parseInt(f.value)
            });

            let price = $(this).closest('tr').find('.price').val();
            price = replaceNumber(price);
            let total = price * $(this).val();

            $(this).closest('tr').find('.total_value').val(total);
            total = formatNumber(total);
            $(this).closest('tr').find('.total').val(total);

            let all_price = 0;
            let price_ = document.querySelectorAll('.list-product .total');
            price_.forEach(f => {
                all_price += parseInt(replaceNumber(f.value))
            });
            $('.all_price').html(formatNumber(all_price));
            $('.all_quantity').html(all_quantity);


            changeTotalValue();
        })

        //change chiết khấu
        $(document).on('keyup', '.discount', function (e) {
            let discount = $(this).val();
            $('.discountValue').val(replaceNumber(discount));
            $('.discount').val(formatNumber(discount));

            changeTotalValue();


        })

        //change khách đặt cọc
        $(document).on('keyup', '.advancePrice', function (e) {
            let advancePrice = $(this).val();
            $('.advancePriceValue').val(replaceNumber(advancePrice));
            $('.advancePrice').val(formatNumber(advancePrice));

            changeTotalValue();

        })


        //change phí vận chuyển
        $(document).on('keyup', '.shipPrice', function (e) {
            let shipPrice = $(this).val();
            $('.shipPriceValue').val(replaceNumber(shipPrice));
            $('.shipPrice').val(formatNumber(shipPrice));
            changeTotalValue();
        })

        $('body').delegate('.delete-item', 'click', function () {
            let quantity = $(this).closest('tr').find('.quantity').val();
            let total = $(this).closest('tr').find('.total').val();
            quantity = replaceNumber(quantity);
            total = replaceNumber(total);
            let all_price = $('.all_price').html();
            let all_quantity = $('.all_quantity').html();
            all_price = replaceNumber(all_price) - total;
            all_quantity = replaceNumber(all_quantity) - quantity;
            $('.all_price').html(formatNumber(all_price));
            $('.all_quantity').html(all_quantity);

            $(this).closest('tr').remove();
            changeTotalValue();
        })


        function elementHtmlToString(who, deep) {
            if (!who || !who.tagName) return '';
            var txt, ax, el = document.createElement("div");
            el.appendChild(who.cloneNode(false));
            txt = el.innerHTML;
            if (deep) {
                ax = txt.indexOf('>') + 1;
                txt = txt.substring(0, ax) + who.innerHTML + txt.substring(ax);
            }
            el = null;
            return txt;
        }

        var product_default_source = [];
        $('#depot').change(function () {
            let address = $(this).find(":selected").data('address');
            let value = $(this).find(":selected").val();
            form.find("input[name='address_depot']").val(address);
            change_depot(value,false);
        })

        function change_depot(depot_id,is_change_depot = false){
            let product_id = $(document).find('#product_id')
            let html_product = '<option value="0">--Chọn sản phẩm--</option>';
            if(is_change_depot){
                $('#depot').val(depot_id).change();
            }
            $.ajax({
                url: '/ajax/product-deport/' + depot_id,
                success: function (data) {
                    let product = data.product;
                    product.forEach(element => {
                        html_product += `<option data-price="` + element.product.price + `" value="` + element.product_id + `">` + element.product.name + `</option>`
                    });
                    product_id.html(html_product);

                    $('.all_quantity').html('');
                    $('.all_price').html('');


                    let list_product = product.map(m => {
                        return m.product.id
                    });
                    var html = '';
                    for (let r = 0; r < product_default_source.length; r++) {
                        let product_id1 = $(product_default_source[r]).data('id');
                        if (list_product.indexOf(product_id1) > -1) {
                            html += elementHtmlToString(product_default_source[r], true)
                        }
                    }

                    $('.list-product').html(html);
                    changeTotal();
                    changeTotalValue();
                }
            })
        }

        form.submit(function (e, page) {
            showLoading();
            $.post($(this).attr('action'), $(this).serialize(), function (data) {
                if (data.order_id) {
                    form.append(`<input type="hidden" value="` + data.order_id + `" name="order_id" class="getOrderId">`);
                }
                if (data.success) {
                    alertify.success(data.message)
                } else {
                    alertify.error(data.message)
                }
                if (data.save_order) {
                    $('.chotDon').show();
                }
                hideLoading();
            });
            return false;
        });

        // chốt đơn
        $(document).on('click', '.submitForm', function () {
            form.attr('action', '/order');
            $("input[name=_method]").remove();
            if (!$('#depot').val()) {
                $('#code-error').show();
            } else {
                $('#code-error').hide()
            }

            if ($('.customerGioiThieu').val() && !$('.selectSource').val() && !$('#selectSourceGT').val()) {
                $('#code-error-source').show();
                return;
            } else {
                $('#code-error-source').hide()
            }

            if (!$('.name').val()) {
                $('#code-error-name').show();
                return;
            } else {
                $('#code-error-name').hide()
            }
            if (!$('.phone').val()) {
                $('#code-error-phone').show();
                return;
            } else {
                $('#code-error-phone').hide()
            }

            if (!$('.city').val()) {
                $('#code-error-city').show();
                return;
            } else {
                $('#code-error-city').hide()
            }
            if (!$('.district').val()) {
                $('#code-error-district').show();
                return;
            } else {
                $('#code-error-district').hide()
            }
            if (!$('.wards').val()) {
                $('#code-error-ward').show();
                return;
            } else {
                $('#code-error-ward').hide()
            }


            if (!$('#depot').val() || ($('.customerGioiThieu').val() && !$('.selectSource').val() && !$('#selectSourceGT').val()) || !$('.name').val() || !$('.phone').val()) {
                return;
            }


            $("#validateForm").submit();
            $('.submitForm').hide();
            $('.huyChotDon').show();

            setTimeout(function () {
                $('.searchData').click();
            }, 1000)
        })

        // change city
        $('#city').on("select2:select", function (e) {
            const city_code = e.target.value;
            let html_district = '';
            let html_wards = '';
            let row_district = $('body').find('#district');
            let row_wards = $('body').find('#wards');

            $.ajax({
                url: '/ajax/searchDistrict/' + city_code,
                success: function (data) {
                    let districts = data.districts;
                    let wards = data.wards;
                    districts.forEach(element => {
                        let value = element.code;
                        html_district += `<option value="` + value + `">` + element.name + `</option>`
                    });
                    wards.forEach(element => {
                        let value = element.code;
                        html_wards += `<option value="` + value + `">` + element.name + `</option>`
                    })
                    row_district.html(html_district);
                    row_wards.html(html_wards);

                    if(data.depot){
                        change_depot(data.depot.id,true);
                    } else {
                        $('#depot').val('').change();
                    }
                }
            })
        });

        // change district
        $('#district').on("change", function (e) {
            const district_code = e.target.value;
            let html_wards = '';
            let row_wards = $('body').find('#wards');

            $.ajax({
                url: '/ajax/searchWards/' + district_code,
                success: function (data) {
                    let wards = data.wards;
                    wards.forEach(element => {
                        let value = element.code;
                        html_wards += `<option value="` + value + `">` + element.name + `</option>`
                    })
                    row_wards.html(html_wards);
                }
            });
        });

        function addDataChat(page_id, sender_id, token) {
            $('.chat-page_id').val(page_id);
            $('.chat-sender_id').val(sender_id);
            $('.chat-token').val(token);
        }


        //tạo đơn giới thiệu
        $(document).on('click', '.showPopupEdit', function () {
            document.getElementById("phone").readOnly = false;

            $('#selectSourceGT').next(".select2-container").show();
            $('#selectSource').next(".select2-container").hide();

            $('.selectSourceGT').show();
            $('.selectSource').hide();

            $('.customerId').val('');
            resetValue();

            form.append(`<input class="customerGioiThieu" type="hidden" name="gioi_thieu" value="1">`);

            $('#myModalLabel35').html('Tạo đơn mới').trigger('change');

            $('.chatContent').html('');

            let html = '<option></option>';
            let row = $('#selectSourceGT');
            $.ajax({
                url: "/ajax/marketing/sale-get-source",
                success: function (data) {
                    if (data && data.length > 0) {
                        data.forEach(function (item) {
                            html += `
                            <option value="` + item.id + `">` + item.name + `<option>
                        `
                        })

                        row.html(html);
                    }
                }
            });


            $('#bootstrap').modal('show');
        })


        $(document).ready(function () {
            $(document).on('focusout', '#phone', function () {
                let phone = $(this).val();
                if (!phone) {
                    return;
                }
                $.ajax({
                    url: '/ajax/sale/search-phone-customer',
                    data: {phone: phone},
                    success: function (data) {
                        if (data) {
                            let html = 'Trùng số, ' + 'Source: ' + data.source.name;
                            $('#check-phone-exists').html(html);
                            $('#check-phone-exists').show();
                        } else {
                            $('#check-phone-exists').hide();
                        }
                    }
                })
            })

            $('#selectSourceGT').on('select2:select', function (e) {
                console.log(1123, e.target.value);
            });

            function formatState(state) {
                console.log(state);
                if (!state.id) {
                    return state.text;
                }
                let $state = $(
                    `<option>` + state.text + `</option>`
                );
                return $state;
            };

            $('.js-data-example-ajax').select2({
                minimumInputLength: 3,
                allowClear: true,
                ajax: {
                    url: '/ajax/marketing/sale-get-source',
                    dataType: 'json',
                    templateResult: formatState,
                    data: function (term) {
                        return {
                            term: term
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    text: item.name,
                                    id: item.id
                                }
                            })
                        };
                    }
                }
            });


        })

        function getSelectedDistrict(code_city, code_selected, element) {
            $.ajax({
                url: "/ajax/searchDistrict/" + code_city,
                success: function (data) {
                    if (data && data.districts.length > 0) {
                        let html = '';
                        let row = $(element);
                        data.districts.forEach(item => {
                            let selected = item.code == code_selected ? "selected" : '';
                            html += `<option value= "` + item.code + `"  ` + selected + ` >` + item.name + `</option>`
                        })
                        row.html(html);
                    }
                }
            })
        }

        function getSelectedWards(code_district, code_selected, element) {
            $.ajax({
                url: "/ajax/searchWards/" + code_district,
                success: function (data) {
                    if (data && data.wards.length > 0) {
                        let html = '';
                        let row = $(element);
                        data.wards.forEach(item => {
                            let selected = item.code == code_selected ? "selected" : '';
                            html += `<option value= "` + item.code + `"  ` + selected + ` >` + item.name + `</option>`
                        })
                        row.html(html);
                        console.log(2342324234, html, row);
                    }
                }
            })
        }


        //open form
        $(document).on('click', '.openFormOperation', function () {
            $('#selectSourceGT').next(".select2-container").hide();
            $('#selectSource').next(".select2-container").show();
            document.getElementById("phone").readOnly = true;

            let item = $(this).data('item');
            let source_name = item.source ? item.source.name : '';
            $('.selectSource').html(`<option value="` + item.source_id + `">` + source_name + `</option>`)

            $('.chatContent').html('');
            resetValue();
            $('#validateForm .description').val('Hàng dễ vỡ xin nhẹ tay !');

            if (item.page_id && item.FB_ID && item.fanpage) {
                $('.showHistoryChat').show();
                addDataChat(item.page_id, item.FB_ID, item.fanpage.access_token);
            } else {
                $('.showHistoryChat').hide();
            }


            let id = $(this).data('id');
            let source_id = $(this).data('source');
            let row_html = '';
            let row = $(document).find('.list-product');


            let message_customer = $(this).closest('tr').find('.messageCustomer').val();

            $(document).find('.name').val(item.name);
            $(document).find('.phone').val(item.phone);
            $(document).find('.customerId').val(item.id);
            $(document).find('.saleId').val(item.user_id);
            $(document).find('.mktId').val(item.mkt_id);
            $(document).find('.sourceId').html(`<option value="` + item.source.id + `" selected>` + item.source.name + `</option>`);

            $.ajax({
                url: '/ajax/sale/getOrderDetail/' + id,
                data: {
                    id: id,
                    source_id: source_id
                },
                success: function (data) {
                    //trường hợp chưa có đơn hàng
                    if (data.source.length > 0 && data.order.length == 0) {
                        $('.submitForm').show();
                        $('.chotDon').hide();
                        $('.huyChotDon').hide();
                        $(document).find('.messages').val(message_customer);
                        data.source[0].products.forEach(item => {
                            row_html += `
                                 <tr data-id="` + item.id + `">
                                    <input type="hidden" name="product[]" value="` + item.id + `">
                                     <td class="text-center">` + item.name + `</td>
                                     <td class="text-center">còn hàng</td>
                                     <td class="text-center">
                                        <input type="hidden" name="price[]" class="price_value" value="` + item.price + `">
                                        <input readonly type="text" maxlength="5" value="` + formatNumber(item.price) + `"
                                        class="form-control text-center txt-dotted price"style="height: 23px !important;">
                                     </td>
                                     <td class="text-center">
                                          <input type="number" maxlength="5" required autocomplete="0"
                                                               class="form-control text-center txt-dotted quantity"
                                                               style="height: 23px !important;" name="quantity[]">
                                    </td>
                                     <td class="text-center">
                                        <input type="hidden" name="total_item[]" class="total_value">
                                        <input readonly type="text" maxlength="5"
                                                               class="form-control text-center txt-dotted total"
                                                               style="height: 23px !important;">
                                    </td>
                                    <td class="text-center"><a class="delete-item" href="javascript:void(0)"><i class="fa fa-trash"></i></a></td>
                                </tr>
                            `
                        })
                        row.html(row_html);

                        $('#bootstrap').modal('show');
                        product_default_source = $('tbody.list-product tr');
                    } else { //trường hợp có đơn hàng
                        let order = data.order[0];
                        if(order.status != 0){
                            $('#bootstrap .submitForm').hide();
                        }
                        let customer_name = order.customer_name ? order.customer_name : '';
                        if (customer_name) {
                            $('#bootstrap').find('.name').val(customer_name);
                        }
                        getSelectedDistrict(order.city_id, order.district_id, '.district');
                        getSelectedWards(order.district_id, order.ward_id, '.wards');

                        if (order.productDepot.length > 0) {
                            let row = `<option selected="">--Chọn sản phẩm--</option>`;
                            order.productDepot.forEach(item => {

                                row += `
                                <option data-price="` + item.product.price + `"
                                                    value="` + item.product_id + `">` + item.product.name + `</option>
                            `
                            });
                            $("#product_id").html(row);
                        }

                        if (order.status >= 1 && order.status != 4) { //đơn đã chốt
                            $('.submitForm').hide();
                            $('.chotDon').hide();
                            $('.huyChotDon').show();

                        } else if (order.status == 0) { //đơn đã lưu
                            $('.submitForm').show();
                            $('.chotDon').show();
                            $('.huyChotDon').hide();
                        } else if (order.status == 4) { //đơn đã hủy
                            setTimeout(() => {
                                $(document).find('#depot').val('');
                            }, 200)
                        }

                        form.append(`<input class="getOrderId" type="hidden" value="` + order.id + `" name="order_id">`)
                        form.append(`<input class="getOrderStatus" type="hidden" value="` + order.status + `" name="order_status">`)


                        if (order.city_id != '0') {
                            $(document).find('.city').val(order.city_id).change();
                            // $(document).find('.district').html(`<option value="` + order.location.district.code + `" selected>` + order.location.district.name + `</option>`);
                            // $(document).find('.wards').html(`<option value="` + order.location.ward.code + `" selected>` + order.location.ward.name + `</option>`);
                        }

                        if (order.is_upsale == 1) {
                            $('#is_upsale').prop('checked', true);
                        }

                        $(document).find('#depot').val(order.depot_id);
                        $(document).find('.address').val(order.address);
                        $(document).find('.description').val(order.description);
                        $(document).find('.messages').val(message_customer);
                        $('.all_price').html(formatNumber(order.total + order.discount + order.advance_price - order.ship_price));

                        $('.discount').val(formatNumber(order.discount));
                        $('.discountValue').val(order.discount);

                        $('.advancePrice').val(formatNumber(order.advance_price));
                        $('.advancePriceValue').val(order.advance_price);

                        $('.totalPrice').val(formatNumber(order.total));
                        $('.totalPriceValue').val(order.total);

                        $('.shipPrice').val(formatNumber(order.ship_price));
                        $('.shipPriceValue').val(order.ship_price);

                        let total_quantity = 0;

                        order.order_details.forEach(item => {
                            total_quantity += item.quantity;
                            row_html += `
                                 <tr data-id="` + item.product_id + `">
                                    <input type="hidden" name="product[]" value="` + item.product_id + `">
                                     <td class="text-center">` + item.product.name + `</td>
                                     <td class="text-center">còn hàng</td>
                                     <td class="text-center">
                                        <input type="hidden" name="price[]" class="price_value" value="` + item.price + `">
                                        <input readonly type="text" maxlength="5" value="` + formatNumber(item.price) + `"
                                        class="form-control text-center txt-dotted price"style="height: 23px !important;">
                                     </td>
                                     <td class="text-center">
                                          <input type="number" autocomplete="0" maxlength="5" value="` + item.quantity + `" required
                                                               class="form-control text-center txt-dotted quantity"
                                                               style="height: 23px !important;" name="quantity[]">
                                    </td>
                                     <td class="text-center">
                                        <input type="hidden" name="total_item[]" class="total_value" value="` + item.total_price + `">
                                        <input readonly type="text" maxlength="5" value="` + formatNumber(item.total_price) + `"
                                                               class="form-control text-center txt-dotted total"
                                                               style="height: 23px !important;">
                                    </td>
                                    <td class="text-center"><a class="delete-item" href="javascript:void(0)"><i class="fa fa-trash"></i></a></td>
                                </tr>
                            `
                        })
                        $('.all_quantity').html(total_quantity);
                        row.html(row_html);
                        $('#bootstrap').modal('show');
                        product_default_source = $('tbody.list-product tr');
                    }
                }
            });
        })

        //thêm đơn mới cho khách
        $(document).on('click', '.openFormAddOrder', function () {
            $('#selectSourceGT').next(".select2-container").hide();
            $('#selectSource').next(".select2-container").show();
            $('#validateForm .description').val('Hàng dễ vỡ xin nhẹ tay !').change();


            document.getElementById("phone").readOnly = true;
            if (confirm("Có chắc chắn thêm đơn mới!")) {
                resetValue();
                let customer_id = $(this).data('id');
                let source_id = $(this).data('source');
                let row_html = '';
                let row = $(document).find('.list-product');

                let item = $(this).data('item');

                $('.selectSource').html(`<option value="` + item.source_id + `">` + item.source.name + `</option>`)

                $('.chatContent').html('');
                if (item.page_id && item.FB_ID && item.fanpage) {
                    $('.showHistoryChat').show();
                    addDataChat(item.page_id, item.FB_ID, item.fanpage.access_token);
                } else {
                    $('.showHistoryChat').hide();
                }
                let message_customer = $(this).closest('tr').find('.messageCustomer').val();

                $(document).find('.name').val(item.name);
                $(document).find('.phone').val(item.phone);
                $(document).find('.customerId').val(item.id);
                $(document).find('.saleId').val(item.user_id);
                $(document).find('.mktId').val(item.mkt_id);
                $(document).find('.sourceId').html(`<option value="` + item.source.id + `" selected>` + item.source.name + `</option>`);

                $.ajax({
                    url: '/ajax/sale/getOrderDetail/' + customer_id,
                    data: {
                        id: customer_id,
                        source_id: source_id
                    },
                    success: function (data) {
                        let order = data.order[0];
                        let customer_name = order.customer_name ? order.customer_name : '';
                        if (customer_name) {
                            $('#bootstrap').find('.name').val(customer_name);
                        }

                        if (order.productDepot.length > 0) {
                            let row = `<option selected="">--Chọn sản phẩm--</option>`;
                            order.productDepot.forEach(item => {

                                row += `
                                <option data-price="` + item.product.price + `"
                                                    value="` + item.product_id + `">` + item.product.name + `</option>
                            `
                            });
                            $("#product_id").html(row);
                        }

                        $('.submitForm').show();
                        $('.chotDon').hide();
                        $('.huyChotDon').hide();
                        form.append(`<input class="getOrderStatus" type="hidden" value="` + order.status + `" name="order_status">`)

                        getSelectedDistrict(order.city_id, order.district_id, '.district');
                        getSelectedWards(order.district_id, order.ward_id, '.wards');

                        if (order.city_id != '0') {
                            $(document).find('.city').val(order.city_id).change();
                            // $(document).find('.district').html(`<option value="` + order.location.district.code + `" selected>` + order.location.district.name + `</option>`);
                            // $(document).find('.wards').html(`<option value="` + order.location.ward.code + `" selected>` + order.location.ward.name + `</option>`);
                        }

                        $(document).find('#depot').val(order.depot_id);
                        $(document).find('.address').val(order.address);
                        $(document).find('.description').val(order.description);
                        $(document).find('.messages').val(message_customer);
                        let total_quantity = 0;

                        order.order_details.forEach(item => {
                            total_quantity += item.quantity;
                            row_html += `
                                 <tr data-id="` + item.product_id + `">
                                    <input type="hidden" name="product[]" value="` + item.product_id + `">
                                     <td class="text-center">` + item.product.name + `</td>
                                     <td class="text-center">còn hàng</td>
                                     <td class="text-center">
                                        <input type="hidden" name="price[]" class="price_value" value="` + item.price + `">
                                        <input readonly type="text" maxlength="5" value="` + formatNumber(item.price) + `"
                                        class="form-control text-center txt-dotted price"style="height: 23px !important;">
                                     </td>
                                     <td class="text-center">
                                          <input type="number" maxlength="5" required
                                                               class="form-control text-center txt-dotted quantity"
                                                               style="height: 23px !important;" name="quantity[]">
                                    </td>
                                     <td class="text-center">
                                        <input type="hidden" name="total_item[]" class="total_value">
                                        <input readonly type="text" maxlength="5"
                                                               class="form-control text-center txt-dotted total"
                                                               style="height: 23px !important;">
                                    </td>
                                    <td class="text-center"><a class="delete-item" href="javascript:void(0)"><i class="fa fa-trash"></i></a></td>
                                </tr>
                            `
                        })
                        row.html(row_html);
                        $('#bootstrap').modal('show');
                        product_default_source = $('tbody.list-product tr');
                    }
                });
            }
        })

        //hủy chốt đơn
        $(document).on('click', '.huyChotDon', function () {
            let id = $('.getOrderId').val();
            swal({
                title: 'Bạn có chắc chắn hủy đơn này?',
                type: 'error',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                showCloseButton: true,
            }).then(function () {
                $.ajax({
                    data: {
                        data_status: 2,
                        order_id: id
                    },
                    url: '/ajax/order/sale-huy-don',
                    method: 'put',
                    success: function (data) {
                        if (data.success) {
                            alertify.success('Hủy thành công !');
                            $('.searchData').click();
                            // setTimeout(() => {
                            //     location.href = '/sale/operation';
                            // }, 1000)
                        } else {
                            alertify.error(data.message);
                        }

                    }
                });
            }, function (dismiss) {
            });
        })
        function getProduct_text(arr_orderDetail){
            console.log(456456456465,arr_orderDetail);
            let html = '';
            if(arr_orderDetail && arr_orderDetail.length > 0){
                arr_orderDetail.forEach(item=>{
                    html+= item.product.name + ' (' + item.quantity + ') </br>'
                })
            }
            return html;
        }

        // click phone number (trùng số)
        $(document).on('click', '.phoneNumber', function () {
            let phone = $(this).data('phone');
            let row = $(document).find('.list-order-phone-number');
            row.html('');
            let row_html = '';
            $.ajax({
                url: '/get-order-phoneNumber/' + phone,
                success: function (data) {
                    data.forEach(element => {
                        let source_name = element.source ? element.source.name : '';
                        let sale_name = element.sale ? element.sale.name : '';
                        let customer_status = element.customer_status ? element.customer_status.name : '';
                        if (element.orders.length > 0) {
                            element.orders.forEach(el => {
                                console.log(234234324, el)

                                let order_status = el.order_status ? el.order_status.name : '';
                                let is_upsale = el.is_upsale ? '(Upsale)' : '';
                                let name = el.customer_name ? el.customer_name : element.name;
                                let total = new Intl.NumberFormat('de-IT', {
                                    style: 'currency',
                                    currency: 'VND'
                                }).format(el.total + el.advance_price);

                                // let html_product = '';
                                // if(el.order_details && el.order_details.length > 0){
                                //     el.order_details.forEach(item=>{
                                //         html_product+= item.product.name + ' (' + item.quantity + ') </br>'
                                //     })
                                // }

                                let product_text = getProduct_text(el.order_details);
                                row_html += `
                                     <tr>
                                        <td class="text-center">` + el.id + `</td>
                                        <td class="text-center">` + source_name + ` <br> ` + element.created_at + `</td>
                                        <td class="text-center">` + name + ' ' + is_upsale + `</td>
                                        <td class="text-center">` + element.message + `</td>
                                        <td class="text-center">` + sale_name + `</td>
                                        <td class="text-center">` + customer_status + `</td>
                                        <td class="text-center">` + product_text +`</td>
                                        <td class="text-center">` + total + `</td>
                                        <td class="text-center">` + el.created_at + `</td>
                                        <td class="text-center">` + el.code + ` <br> ` + order_status + `</td>
                                        <td class="text-center"></td>
                                    </tr>
                                `
                            })

                        } else {
                            row_html += `
                                 <tr>
                                    <td class="text-center">` + element.id + `</td>
                                    <td class="text-center">` + element.source.name + ` <br> ` + element.created_at + `</td>
                                    <td class="text-center">
                                        ` + element.name + `
                                        <br>
                                        ` + element.phone + `
                                    </td>
                                    <td class="text-center">` + element.message + `</td>
                                    <td class="text-center">` + element.sale.name + `</td>
                                    <td class="text-center">` + customer_status + `</td>
                                    <td class="text-center"></td>
                                    <td class="text-center"></td>
                                    <td class="text-center"></td>
                                    <td class="text-center"></td>
                                </tr>
                            `
                        }

                    })
                    row.html(row_html);
                }
            });
            $('#modalPhoneNumber').modal('show');
        })

        // thay đổi trạng thái
        $('.changeCustomerStatus').on('change', function (e) {
            let status_id = $(this).val();
            let customer_id = $(this).data('id');
            let self = $(this);
            let check_open_modal = $(this).closest('tr').find('.checkOrderLast').val();

            $.ajax({
                data: {
                    status_id: status_id,
                    customer_id: customer_id
                },
                url: '/ajax/customer/change-status',
                method: 'put',
                success: function (data) {
                    if (data && data.success === true) {
                        let html = '<option></option>';
                        let row = '.changeCustomerStatus-id-' + customer_id;
                        if (data.arr_status_child.length > 0) {
                            data.arr_status_child.forEach(item => {
                                html += `
                                            <option value="` + item.id + `">` + item.name + `</option>
                                        `
                            })
                            $(row).html(html);
                        }

                        if (status_id == 15) { //chốt đơn bật modal
                            if (check_open_modal) {
                                console.log(123123, check_open_modal);
                                self.closest('tr').find('.openFormAddOrder').click();
                            } else {
                                console.log(232323, check_open_modal);
                                self.closest('tr').find('.openFormOperation').click();
                            }
                        }
                        alertify.success('Thay đổi thành công !');
                        self.closest('tr').attr('style', '');

                    } else if (data && data.success === false) {
                        alertify.error(data.message);
                    } else {
                        alertify.error('Đã có lỗi xảy ra !');
                    }
                }
            });
        });

        function resetValue() {
            $('.messages').val('');
            $('#depot').val('');
            $('#code-error').hide();
            $('#code-error-source').hide();
            $('#code-error-name').hide();
            $('#code-error-phone').hide();
            $('#check-phone-exists').hide();
            $('.quantity').val('');
            $('.all_quantity').html('');
            $('.all_price').html('');
            $('.getOrderId').remove();
            $('.getOrderStatus').remove();
            $('.totalPrice').val('');
            $('.shipPrice').val('');
            $('.totalPriceValue').val('');

            $('.discount').val('');
            $('.discountValue').val('');
            $('.advancePrice').val('');
            $('.advancePriceValue').val('');

            $('.sourceId').val('');
            $('.name').val('');
            $('.phone').val('');
            $('.address').val('');
            $('.description').val('');
            $('.list-product').html('');

            $('.customerGioiThieu').remove();
            $('.showHistoryChat').hide();
            $('.submitForm').show();
            $('.huyChotDon').hide();
            $('#myModalLabel35').html('Cập nhật đơn');

            $('.city').val(0).change();
            $('.district').html('');
            $('.wards').html('');
            $('#is_upsale').prop('checked', false);
        }

        function changeTotalValue() {
            let all_price = $('.all_price').html();
            all_price = replaceNumber(all_price);

            let chiet_khau = Number($('.discountValue').val());
            let dat_coc = Number($('.advancePriceValue').val());
            let ship_price = Number($('.shipPriceValue').val());

            let total = all_price - (chiet_khau + dat_coc) + ship_price;

            $('.totalPrice').val(formatNumber(total));
            $('.totalPriceValue').val(total);
        }


        //update note
        $(document).on('click', '.saveNote', function () {
            let sale_note = $(this).closest('td').find('.textarea-resize.saleNote').val();
            let message = $(this).closest('tr').find('.messageCustomer').val();
            let self = $(this);
            $.ajax({
                url: "/ajax/sale-note",
                data: {
                    customer_id: $(this).data('id'),
                    sale_note: sale_note,
                    message: message
                },
                method: 'put',
                success: function (data) {
                    if (data) {
                        alertify.success("Thành công !");
                        self.closest('tr').attr('style', '');
                        if (data.expired_time_sale || data.time_move_sale) {
                            self.closest('tr').find('.expired_text').html(data.expired_time_sale).change();
                            self.closest('tr').find('.time_move').html(data.time_move_sale).change();
                        }
                    } else {
                        alertify.error("Đã có lỗi xảy ra !");
                    }
                }
            })
        })

        //update note not update history
        $(document).on('focusout', '.saleNote', function () {
            console.log(23423423423442);
            let sale_note = $(this).closest('td').find('.textarea-resize.saleNote').val();
            $.ajax({
                url: "/ajax/sale-note-custom",
                data: {
                    customer_id: $(this).closest('tr').find('.saveNote').data('id'),
                    sale_note: sale_note,
                },
                method: 'put',
                success: function (data) {
                    if (data) {
                        alertify.success("Thành công !")
                    } else {
                        alertify.error("Đã có lỗi xảy ra !")
                    }
                }
            })
        })

        // show hẹn lịch
        $(document).on('click', '.createCalendar', function () {
            let customer_id = $(this).data('id');
            $('.job_customer_id').val(customer_id);
            $('#modalHenLich').modal('show');
        })

        // lưu hẹn lịch
        $(document).on('click', '.saveHenLich', function () {

            let customer_id = $('.job_customer_id').val();

            $.ajax({
                url: '/ajax/sale/save-job-schedule',
                method: 'post',
                data: {
                    customer_id: customer_id,
                    time: $('#demo').val()
                },
                success: function (data) {
                    if (data) {
                        alertify.success('Hẹn lịch thành công');
                    }
                }
            })
        })

    </script>
    <script type="text/javascript" src="{{asset('backend/js/create_order.js')}}"></script>
    <script type="text/javascript" src="{{asset('backend/js/update_order.js')}}"></script>

    <script type="text/javascript" src="{{asset('js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/daterangepicker.min.js')}}"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('css/daterangepicker.css')}}"/>
    <script type="text/javascript" src="{{asset('js/dateranger-config.js')}}"></script>
    @include('components.tin_nhan_noi_bo.js_internal_message')
    @include('components.lich_su_tac_nghiep.js_history_operation')
    @include('components.chat_application.js_chat_app')
@endsection
