@extends('backend.layouts.master')
@section('content')
    <style>
        input.select2-search__field {
            margin-top: 0 !important;
        }

        .modal-header.bg-main {
            height: 35px;
        }

        .modal-header.bg-main .modal-title {
            line-height: 10px;
            font-size: 18px;
        }

        thead {
            position: sticky;
            top: 0;
            z-index: 200;
        }

        @media only screen and (max-width: 1919px) {
            .total {
                position: sticky;
                top: 113px;
                z-index: 200;
            }
        }

        @media only screen and (max-width: 1440px) {
            .total {
                position: sticky;
                top: 130px;
                z-index: 200;
            }
        }

        @media only screen and (max-width: 1200px) {
            .total {
                position: sticky;
                top: 148px;
                z-index: 200;
            }
        }

        .black {
            color: black;
        }

    </style>
    <div class="content-body">
    @php
        $is_admin = Auth::user()->department_id == \App\Constants\DepartmentConstant::ADMIN ? true : false;
        $is_ceo = Auth::user()->department_id == \App\Constants\DepartmentConstant::CEO ? true : false;
        $is_leader = Auth::user()->is_leader == \App\Constants\DepartmentConstant::IS_LEADER ? true : false;
    @endphp
    <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}
                        <div class="card-header fix-header bottom-card add-paginate">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">5.3 Thống kê tất cả nhóm Sale</h4>

                                <div class="col-lg-3 col-md-6">
                                    <input type="hidden" name="start_date" id="start_date">
                                    <input type="hidden" name="end_date" id="end_date">
                                    <input id="reportrange" type="text" class="form-control square">
                                </div>

                                <div class="col-lg-2 col-md-6">
                                    <select name="type_search" id="" class="select2" data-placeholder="--Kiểu lọc--">
                                        <option></option>
                                        <option value="2">Doanh số tạm tính</option>
                                        <option value="1">Doanh thu tạm tính</option>
                                    </select>
                                </div>

                                <button class="btn btn-primary"><i class="fa fa-search"></i> Tìm kiếm</button>
                            </div>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        {!! Form::close() !!}
                        <div class="card-header fix-header"></div>

                        <div class="card-content collapse show">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        @include('backend.sale.leader.team_sale_ajax')
                                        <div class="mt-2">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

@endsection
@section('script')
    @include('backend.layouts.script')
    <script type="text/javascript" src="{{asset('js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/daterangepicker.min.js')}}"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('css/daterangepicker.css')}}"/>
    <script type="text/javascript" src="{{asset('js/dateranger-config.js')}}"></script>
@endsection
