@extends('backend.layouts.master')
@section('content')
    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => '/sale/depot-number-float', 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}
                            <div class="card-header fix-header bottom-card add-paginate">
                                <div class="row" style="align-items: baseline">
                                    <h4 class="col-lg-3">4.5 Kho số thả nổi</h4>
                                    <div class="col-lg-2 col-md-6">
                                        <input type="text" class="form-control square" name="name"
                                               placeholder="Họ tên">
                                    </div>
                                    <div class="col-lg-2 col-md-6">
                                        <input type="text" class="form-control square" name="phone"
                                               placeholder="Số điện thoại">
                                    </div>
                                    {{--<div class="col-2">--}}
                                        {{--<select class="select2 square" name="" id="" data-placeholder="--Kiểu ngày--">--}}
                                            {{--<option></option>--}}
                                            {{--<option value="1">Ngày data về hệ thống</option>--}}
                                        {{--</select>--}}
                                    {{--</div>--}}

                                    <button class="btn btn-primary searchData"><i class="fa fa-search"></i> Tìm kiếm</button>
                                </div>
                                <div class="heading-elements">
                                    <ul class="list-inline mb-0">
                                        <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                        {{ Form::close() }}
                        <div class="card-header fix-header"></div>
                        <div class="card-content collapse show">
                            <div class="card-body">
                                @include('backend.sale.customer.ajax_depot_number')

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>
    </div>
@endsection
@section('script')
    @include('backend.layouts.script')
    <script>
        $(document).on('change', '.sale', function () {
            let id = $(this).data('id');
            let sale = $(this).val();

            swal({
                title: 'Bạn có chắc chắn chuyển?',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                showCloseButton: true,
            }).then(function () {
                $.ajax({
                    url: '/ajax/sale/phan-bo-data',
                    method: 'PUT',
                    data: {
                        khach_hang_id: [id],
                        user_id: sale,
                    },
                    success: function (data) {
                        if (data) {
                            window.location.reload();
                        }
                    }
                })
            }, function (dismiss) {
            });

        })
    </script>
@endsection
