@extends('backend.layouts.master')
@section('content')
    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}
                        <div class="card-header fix-header bottom-card add-paginate">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">1.1 Danh sách sản phẩm</h4>
                                <div class="col-lg-3 col-md-6">
                                    <input name="name" type="text" class="form-control square"
                                           placeholder="Tìm kiếm tên ...">
                                </div>
                                <button type="submit" class="btn btn-primary searchData" id="btnSearch"><i
                                        class="fa fa-search"></i> Tìm kiếm
                                </button>
                            </div>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        {{ Form::close() }}
                        <div class="card-header fix-header">
                            <button class="btn btn-primary" data-toggle="modal" data-target="#add_new"><i
                                    class="fa fa-plus"></i> Thêm mới
                            </button>
                            <button class="btn btn-warning" data-toggle="modal" data-target="#import"><i
                                    class="fa fa-file-excel-o"></i> Import sản phẩm
                            </button>
                        </div>
                        <div class="card-content collapse show">
                            <div class="card-body">
                                @include('backend.products.ajax')
                                @include('backend.products._form')
                                @include('backend.products.import')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- // card-actions section end -->
    </div>
@endsection
@section('script')
    @include('backend.layouts.script')
    <!-- file upload -->
    <script src="/js/file_upload.js"></script>
    <script>

        $('body').delegate('.edit', 'click', function () {
            let url = $(this).data('url');
            let form = $('#validateForm');
            $.ajax({
                type: "get",
                url: url,
                success: function (data) {
                    console.log(12313,data.category_id);
                    form.attr('action', location.href + '/' + data.id);
                    form.attr('method', 'POST');
                    $('#myModalLabel').html('CẬP NHẬT SẢN PHẨM').change();
                    $('.value-form').append('<input name="_method" type="hidden" value="PUT">');
                    form.find("input[name='code']").val(data.code);
                    form.find("input[name='name']").val(data.name);
                    form.find("input[name='phone']").val(data.phone);
                    form.find("input[name='price']").val(data.price);
                    form.find("input[name='weight']").val(data.weight);
                    form.find("select[name='category_id']").val(data.category_id).change();
                    form.find("textarea[name='description']").val(data.description);
                    $('#add_new').modal('show');
                }
            });
        })

        $().ready(function () {
            $("#validateForm").validate({
                rules: {
                    phone: {
                        required: true,
                        minlength: 10
                    },
                    weight: {
                        required: true,
                    },
                    price: {
                        required: true,
                    },
                    name: 'required',
                    code: 'required',
                },
                messages: {
                    phone: {
                        required: "Vui lòng nhập số điện thoại !",
                        minlength: "Số điện thoại ít nhất 10 số !"
                    },
                    weight: {
                        required: "Vui lòng nhập khối lượng !",
                    },
                    price: {
                        required: "Vui lòng nhập số tiền !",
                    },
                    name: "Vui lòng nhập tên !",
                    code: "Vui lòng nhập mã !"
                }
            })
        });
    </script>
@endsection
