@extends('backend.layouts.master')
@section('content')
    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @if (session('message'))
                            <div class="alert-danger notification">
                                <ul style="list-style: none;text-align: center;">
                                    <li>{{ session('message') }}</li>
                                </ul>
                            </div>
                        @endif
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                        <div class="card-header fix-header bottom-card">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">Thông tin cá nhân</h4>
                            </div>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-header fix-header"></div>
                        <div class="card-content collapse show">
                            <form action="/user-profile" method="post" enctype="multipart/form-data" autocomplete="off">
                                @csrf
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="row">
                                                <div class="col-2">Tên tài khoản</div>
                                                <div class="col-8"><input type="text" class="square form-control" readonly value="{{$user->username}}"></div>
                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Nhóm quyền</div>
                                                <div class="col-8">
                                                    <input type="text" class="square form-control" readonly
                                                                          value="{{$user->department_id == \App\Constants\DepartmentConstant::ADMIN ? 'Admin'
                                                                          :($user->department_id == \App\Constants\DepartmentConstant::CEO ? 'CEO'
                                                                          :($user->department_id == \App\Constants\DepartmentConstant::SALE ? 'Sale'
                                                                          :($user->department_id == \App\Constants\DepartmentConstant::MARKETING ? 'Marketing'
                                                                          :($user->department_id == \App\Constants\DepartmentConstant::ACCOUNTING ? 'Kế toán'
                                                                          :($user->department_id == \App\Constants\DepartmentConstant::WAREHOUSE ? 'Kho':'')))))}}">
                                                </div>
                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Họ và tên</div>
                                                {{--<div class="col-8"><input type="text" class="square form-control" name="name" value="{{$user->name}}"></div>--}}

                                                <div class="col-8 {{$errors->has('name')?'has-error':''}}">
                                                    <input type="text" name="name" class="square form-control"
                                                           value="{{!empty($user)?$user->name:old('name')}}">
                                                    @if ($errors->has('name'))
                                                        <div class="red">{{$errors->first('name')}}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Mã định danh</div>
                                                <div class="col-8"><input type="text" class="square form-control" readonly value="{{$user->id}}"></div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="row">
                                                <div class="col-2">Email</div>
                                                <div class="col-8 {{$errors->has('email')?'has-error':''}}">
                                                    <input type="hidden" class="emailValue" value="{{!empty($user)?$user->email : ''}}">
                                                    <input type="email" name="email" class="square form-control email"
                                                           value="{{!empty($user)?$user->email:old('email')}}">
                                                    @if ($errors->has('email'))
                                                        <div class="red">{{$errors->first('email')}}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Số điện thoại</div>
                                                {{--<div class="col-8"><input type="text" class="square form-control phoneNumber" name="phone" value="{{$user->phone}}"></div>--}}

                                                <div class="col-8 {{$errors->has('phone')?'has-error':''}}">
                                                    <input type="hidden" class="phonelValue" value="{{!empty($user)?$user->phone : ''}}">

                                                    <input type="text" name="phone" class="square form-control phone"
                                                           value="{{!empty($user)?$user->phone:old('phone')}}">
                                                    @if ($errors->has('phone'))
                                                        <div class="red">{{$errors->first('phone')}}</div>
                                                    @endif
                                                </div>


                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Mật khẩu</div>
                                                <div class="col-8"><input type="password" class="square form-control password" name="password" id="password"></div>
                                            </div>
                                            <div class="row mt-1">
                                                <div class="col-2">Nhập lại mật khẩu</div>
                                                <div class="col-8"><input type="password" class="square form-control confirm_password" name="confirm_password" id="confirm_password"></div>
                                            </div>

                                            <div class="row mt-1">
                                                <div class="col-2">Ảnh đại diện</div>
                                                <div class="col-8">
                                                    <div class="customer-avatar">
                                                        <div class="avatar-wrapper">
                                                            <button type="button" class="btn btn-primary action-upload">Chọn ảnh</button>
                                                            <input type="file" name="avatar" id="ip-upload-avatar" accept="image/*" style="visibility: hidden">
                                                        </div>
                                                        <img id="blah" src="{{$user->avatar ? url($user->avatar) : url('images/noavatar.jpg')}}" alt="" style="width: 120px;height: 120px;">
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-1">
                                        <div class="col-6">
                                            <div class="row">
                                                <div class="col-2"></div>
                                                <div class="col-8">
                                                    <button type="submit" class="btn btn-primary submit"><i class="fa fa-save"></i> Lưu</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('script')
    @include('backend.layouts.script')
    <script>

        $(document).ready(function () {
            let abc = $('.emailValue').val();
            if(!abc){
                $('.email').val('').change();
            }
            let abc1 = $('.phonelValue').val();
            if(!abc1){
                $('.email').val('').change();
            }
            $('.password').val('').change();
            $('.confirm_password').val('').change();
        })

        // $(document).on('focusout','#password,#confirm_password',function () {
        //     if($('#password').val() != ''){
        //         if($('#confirm_password').val() != '' && $('#password').val() !==  $('#confirm_password').val()){
        //             alertify.warning('Mật khẩu và xác thực chưa trùng nhau !');
        //         }
        //         if($('#password').val() !==  $('#confirm_password').val()){
        //             $('.submit').prop('disabled',true);
        //         } else {
        //             $('.submit').prop('disabled',false);
        //         }
        //     } else {
        //         $('.submit').prop('disabled',false);
        //
        //     }
        // })

        // $(document).on('focusout','#confirm_password',function () {
        //     if($('#password').val() != '' && $('#confirm_password').val() != ''){
        //         alertify.warning('Mật khẩu và xác thực chưa trùng nhau !');
        //         $('.submit').prop('disabled',true);
        //     } else {
        //         $('.submit').prop('disabled',false);
        //     }
        // })

        $(document).on('click','.action-upload',function(){
            $('#ip-upload-avatar').click();
        })

        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('#blah').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]); // convert to base64 string
            }
        }

        $("#ip-upload-avatar").change(function() {
            readURL(this);
        });

        $('.phoneNumber').on('change',function () {
            let str = $('.phoneNumber').val();
            let patt1 = /^[0-9]*$/g;
            let result = str.match(patt1);

            if(result == null){
                alertify.warning('Số điện thoại không đúng định dạng');
                $('.submit').prop('disabled',true);
            } else {
                $('.submit').prop('disabled',false);
            }
        })
    </script>
@endsection
