@extends('backend.layouts.master')
@section('content')
    <style>
        input.select2-search__field {
            margin-top: 0 !important;
        }

        .modal-header.bg-main {
            height: 35px;
        }

        .modal-header.bg-main .modal-title {
            line-height: 10px;
            font-size: 18px;
        }

        thead {
            position: sticky;
            top: 0;
            z-index: 200;
        }

        @media only screen and (max-width: 1919px) {
            .total {
                position: sticky;
                top: 113px;
                z-index: 200;
            }
        }

        @media only screen and (max-width: 1440px) {
            .total {
                position: sticky;
                top: 130px;
                z-index: 200;
            }
        }

        @media only screen and (max-width: 1200px) {
            .total {
                position: sticky;
                top: 148px;
                z-index: 200;
            }
        }

        .black {
            color: black;
        }
        .select2-container .select2-selection--multiple .select2-selection__rendered {
            display: inline !important;
            /*list-style: none;*/
            padding: 0;

        }
        .select2-container--classic .select2-selection--multiple, .select2-container--default .select2-selection--multiple{
            min-height: 36px !important;
            padding: 0!important;
        }

    </style>
    @php
        $is_leader = Auth::user()->is_leader == \App\Constants\DepartmentConstant::IS_LEADER ? true : false;
        $is_teamlead = count(Auth::user()->teams) > 0 ? true : false;
        $is_admin = Auth::user()->department_id == \App\Constants\DepartmentConstant::ADMIN ? true : false;
        $is_ceo = Auth::user()->department_id == \App\Constants\DepartmentConstant::CEO ? true : false;
    @endphp
    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}
                        <div class="card-header fix-header bottom-card add-paginate">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">3.1 Thống kê trưởng nhóm marketing</h4>

                                <div class="col-lg-3 col-md-6">
                                    <input type="hidden" name="start_date" id="start_date">
                                    <input type="hidden" name="end_date" id="end_date">
                                    <input id="reportrange" type="text" class="form-control square">
                                </div>

                                @if(count($products))
                                    <div class="col-lg-2 col-md-6">
                                        <select name="product_id" id="" class="select2"
                                                data-placeholder="-- Tất cả sản phẩm --">
                                            <option></option>
                                            @foreach($products as $item)
                                                <option value="{{$item->id}}">{{$item->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                @endif

                                <button class="btn btn-primary"><i class="fa fa-search"></i> Tìm kiếm</button>
                            </div>
                            <div class="row mt-1">
                                <div class="col-lg-2 col-md-6">
                                    <select name="team_id[]" id="" class="select2" multiple
                                            data-placeholder="-- Phòng Marketing --">
                                        <option></option>
                                        @forelse($teams as $item)
                                            <option value="{{$item->id}}">{{$item->name}}</option>
                                        @empty
                                            <p>No team</p>
                                        @endforelse

                                    </select>
                                </div>
                                <div class="col-2">
                                    <select class="select2 square" name="status" id=""
                                            data-placeholder="-- Chọn trạng thái giao hàng --">
                                        <option></option>
                                        @forelse ($status_orders as $item)
                                            <option value="{{$item->id}}">{{$item->name}}</option>
                                        @empty
                                            <p>No order status</p>
                                        @endforelse
                                    </select>
                                </div>
                                <div class="col-2">
                                    <select class="select2 square" name="doi_soat"
                                            data-placeholder="-- Chọn đối soát --">
                                        <option></option>
                                        <option value="0">Chưa đối soát</option>
                                        <option value="1">Đã đối soát</option>
                                    </select>
                                </div>
                                <div class="col-2">
                                    <select class="select2 square" name="sau_hoan_huy"
                                            data-placeholder="-- Kiểu lọc --">
                                        <option></option>
                                        <option value="0">Trước hoàn huỷ</option>
                                        <option value="1">Sau hoàn huỷ</option>
                                    </select>
                                </div>
                            </div>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                @if($is_leader || $is_teamlead||$is_admin || $is_ceo)
                                    <li><a class="excel-html" data-toggle="tooltip" data-placement="right"
                                           title="Tải xuống Excel">
                                            <i class="fa fa-cloud-download" style="color: var(--main-color)"></i></a>
                                    </li>
                                @endif
                                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        {!! Form::close() !!}
                        <div class="card-header fix-header"></div>

                        <div class="card-content collapse show">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        @include('backend.marketing.leader.ajax')
                                        <div class="mt-2">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('script')

    @include('backend.layouts.script')
    <script type="text/javascript" src="{{asset('js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/daterangepicker.min.js')}}"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('css/daterangepicker.css')}}"/>
    <script type="text/javascript" src="{{asset('js/dateranger-config.js')}}"></script>

@endsection
