@extends('backend.layouts.master')
@section('content')
    <div class="content-body">
        <!-- card actions section start -->
        @if(\Session::has('success'))
            <div class="alert alert-icon-left alert-info alert-dismissible mb-2" role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
                <strong>{{ \Session::get('success') }}</strong>
                @php
                    \Session::forget('success');
                @endphp
            </div>
        @elseif(\Session::has('error'))
            <div class="alert alert-icon-left alert-danger alert-dismissible mb-2" role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
                <strong>{{ \Session::get('error') }}</strong>
                @php
                    \Session::forget('error');
                @endphp
            </div>
        @endif
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header fix-header bottom-card">
                            {{--<div class="row" style="align-items: baseline">--}}
                            {{--<h4 class="col-lg-3">Nhập data thủ công</h4>--}}
                            {{--<div class="col-lg-3 col-md-6">--}}
                            {{--<fieldset class="form-group">--}}
                            {{--<input type="text" class="form-control square" placeholder="Tìm kiếm tên ...">--}}
                            {{--</fieldset>--}}
                            {{--</div>--}}
                            {{--<button class="btn btn-primary"><i class="fa fa-search"></i> Tìm kiếm</button>--}}
                            {{--</div>--}}
                            {{--<div class="heading-elements">--}}
                            {{--<ul class="list-inline mb-0">--}}
                            {{--<li><a data-action="expand"><i class="ft-maximize"></i></a></li>--}}
                            {{--</ul>--}}
                            {{--</div>--}}
                        </div>
                        <div class="card-content collapse show">
                            <form action="{{route('marketing.custom-data.store')}}" method="post" id="validateForm">
                                @csrf
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-12 form-group">
                                            <div class="notice">
                                                <b>Lưu ý:</b> <br>
                                                - Dữ liệu nhập tại đây được xem giống như dữ liệu nhận về từ landing<br>
                                                - Chỉ hiển thị lựa chọn tối đa 20 landing, vui lòng sử dụng chức năng
                                                tìm
                                                kiếm đề tìm landing cần chọn
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mb-1">
                                        <div class="col-6">
                                            <span class="required">Landing</span>
                                            <select class="select2 form-control" name="source_id" id=""
                                                    data-placeholder="--Chọn nguồn dữ liệu--">
                                                <option></option>
                                                @if(count($sources))
                                                    @foreach($sources as $item)
                                                        <option value="{{$item->id}}">{{$item->name}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-1">

                                        <div class="col-6">
                                            <span class="required">Họ tên khách hàng</span>
                                            <input type="text" class="form-control square" name="name">
                                        </div>
                                    </div>

                                    <div class="row mb-1">
                                        <div class="col-6">
                                            <span class="required">Số điện thoại</span>
                                            <input type="text" class="form-control square" name="phone" id="phone">

                                        </div>
                                    </div>

                                    <div class="row mb-1">
                                        <div class="col-6">
                                            <span class="required">Trạng thái KH</span>
                                            <select class="select2 form-control" name="status" id=""
                                                    data-placeholder="--Chọn trạng thái KH--">
                                                <option></option>
                                                @if(count($status))
                                                    @foreach($status as $item)
                                                        <option value="{{$item->id}}" {{$item->id == 1 ? 'selected' :''}}>{{$item->name}}</option>
                                                    @endforeach
                                                @endif
                                            </select>

                                        </div>
                                    </div>

                                    <div class="row mb-1">
                                        <div class="col-6">
                                            <span class="required">Ghi chú khách hàng (tin nhắn)</span>
                                            <input type="text" class="form-control square " name="message">
                                        </div>
                                    </div>

                                    <div class="row mb-1">
                                        <div class="col-6">
                                            <input class="btn btn-primary" type="submit" value="Lưu lại">
                                        </div>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </section>
    </div>
@endsection
@section('script')
    @include('backend.layouts.script')
    <script>
        $().ready(function () {
            $("#validateForm").validate({
                rules: {
                    phone: {
                        required: true,
                        minlength: 10
                    },
                    message: {
                        required: true,
                    },
                    source_id: {
                        required: true,
                    },
                    status: {
                        required: true,
                    },
                    name: {
                        required: true,
                    },
                },
                messages: {

                    phone: {
                        required: "SDT không được bỏ trống",
                        minlength: "SDT không nhỏ hơn 10 ký tự"
                    },
                    message: {
                        required: "Tin nhắn không được bỏ trống"
                    },
                    status: {
                        required: "Trạng thái không được bỏ trống"
                    },
                    name: {
                        required: "Tên kh không được bỏ trống"
                    },
                }
            })
        });
    </script>
@endsection
