@extends('backend.layouts.master')
@section('content')
    @php
        $is_leader = Auth::user()->is_leader == \App\Constants\DepartmentConstant::IS_LEADER ? true : false;
        $is_teamlead = count(Auth::user()->teams) > 0 ? true : false;
        $is_admin = Auth::user()->department_id == \App\Constants\DepartmentConstant::ADMIN ? true : false;
        $is_ceo = Auth::user()->department_id == \App\Constants\DepartmentConstant::CEO ? true : false;
    @endphp

    <div class="content-body">
        <!-- card actions section start -->
        <section id="card-actions">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        {!! Form::open(array('url' => url()->current(), 'method' => 'get', 'id'=> 'gridForm','role'=>'form')) !!}
                        <div class="card-header fix-header bottom-card add-paginate">
                            <div class="row" style="align-items: baseline">
                                <h4 class="col-lg-3">6.1 Thủ kho tác nghiệp</h4>
                                <div class="col-lg-4 col-md-6">
                                    <input type="hidden" name="start_date" id="start_date">
                                    <input type="hidden" name="end_date" id="end_date">
                                    <input id="reportrange" type="text" class="form-control square">
                                </div>
                                <div class="col-lg-2">
                                    <select name="depot_id" class="form-control square" id="">
                                        <option value="">Tất cả</option>
                                        @if(count($depots))
                                            @foreach($depots as $item)
                                                <option value="{{$item->id}}">{{$item->name}}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>

                                <div class="heading-elements">
                                    <ul class="list-inline mb-0">
                                        @if($is_leader || $is_teamlead||$is_admin || $is_ceo)
                                            <li><a class="excel-html" data-toggle="tooltip" data-placement="right"
                                                   title="Tải xuống Excel">
                                                    <i class="fa fa-cloud-download" style="color: var(--main-color)"></i></a>
                                            </li>
                                        @endif
                                        <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                                    </ul>
                                </div>

                                <button class="btn btn-primary searchData"><i class="fa fa-search"></i> Tìm kiếm
                                </button>


                            </div>
                        </div>
                        {!! Form::close() !!}
                        <div class="card-header fix-header"></div>

                        <div class="card-content collapse show">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12" id="mydiv">
                                        @include('backend.depot.ton_kho.ajax')
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

@endsection
@section('script')
    @include('backend.layouts.script')
    <script type="text/javascript" src="{{asset('js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/daterangepicker.min.js')}}"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('css/daterangepicker.css')}}"/>
    <script type="text/javascript" src="{{asset('js/dateranger-config.js')}}"></script>
@endsection
