<style>
    .btnThemLandingData {
        position: absolute;
        right: 5px;
    }

    .fam-container {
        bottom: 3%;
        position: fixed;
        margin: 1em;
        left: 2.5%;
        z-index: 9999;
        width: 100px;
    }

    .buttons {
        font-size: 11px;
        text-align: center;
        box-shadow: 0px 5px 11px -2px rgba(0, 0, 0, 0.18), 0px 4px 12px -7px rgba(0, 0, 0, 0.15);
        border-radius: 50%;
        display: block;
        width: 56px;
        height: 56px;
        margin: 20px auto 0;
        position: relative;
        -webkit-transition: all .1s ease-out;
        transition: all .1s ease-out;
    }

    .buttons i.fa {
        font-size: 18px;
        color: white;
        line-height: 40px;
    }

    .fam-success {
        background: #51a351;
    }

    .fam-primary {
        background: #6ea543;
    }

    .fam-warning {
        background: #f89406;
    }

    .fam-container:hover .buttons:not(:last-child) {
        margin: 20px auto 0;
        width: 40px;
        height: 40px;
        opacity: 1;
        -webkit-transform: none;
        -ms-transform: none;
        transform: none;
        margin: 15px auto 0;
    }

    .buttons:not(:last-child) {
        width: 0px;
        height: 0px;
        margin: 0px auto 0;
        opacity: 0;
        -webkit-transform: translateY(50px);
        -ms-transform: translateY(50px);
        transform: translateY(50px);
    }

    .buttons:nth-last-child(1) {
        transition-delay: 25ms;
        background-size: contain;
        background: #6ea543;
    }

    .buttons:nth-last-child(1) i {
        color: white;
        font-size: 24px;
        line-height: 55px;
    }
</style>
<nav class="fam-container">
    <a id="btnDangDonGiaoVan" class="buttons fam-primary" data-toggle="tooltip" data-placement="right" title="Đăng đơn">
        <i class="fa fa-calendar-check-o"></i>
    </a>

    <a id="btnHuyDonGiaoVan" class="buttons fam-warning" data-toggle="tooltip" data-placement="right" title="Hủy đăng đơn">
        <i class="fa fa-calendar-times-o"></i>
    </a>

    <a id="btnCapNhatDonNhieu" class="buttons fam-success" data-toggle="tooltip" data-placement="right" title="Cập nhật trạng thái giao hàng">
        <i class="fa fa-truck"></i>
    </a>

    <a class="buttons fam-success" data-toggle="tooltip" data-placement="right" title="In đơn">
        <i class="fa fa-print"></i>
    </a>

    <a id="btnCapNhatDSNBNhieu" class="buttons fam-success" data-toggle="tooltip" data-placement="right" title="Cập nhật đối soát">
        <i class="fa fa-sliders"></i>
    </a>

    <a class="buttons fam-warning" data-toggle="tooltip" data-placement="right" title="Đối soát bằng excel">
        <i class="fa fa-sliders"></i>
    </a>

    <a class="buttons fam-primary exportExcel" data-toggle="tooltip" data-placement="right" title="Xuất Excel kiểu 1">
        <i class="fa fa-file-excel-o"></i>
    </a>

    <a class="buttons fam-success" data-toggle="tooltip" data-placement="right" title="Xuất Excel kiểu 2">
        <i class="fa fa-file-excel-o"></i>
    </a>


    <a class="buttons" tooltip="Share" href="#"><i class="fa fa-bars"></i></a>
</nav>
<div class="tableFixHead table-bordered table-hover table-responsive fixed-scrollbar"
     style="width: 100%; overflow-x: auto;">

    <div class="row col-md-12" style="margin-top: 1rem">
        @if(count($order_status))
            @foreach($order_status as $item)
                <a class="dm-tac-nghiep {{$item->id==$active?'box-active':0}}" data-id="{{$item->id}}">
                                            <span class="flag level-4"
                                                  style="background-color:{{$item->color ? $item->color : '#C1E2F4'}}"></span>
                    <span class="text">{{$item->id == 1 ? "Chờ vận đơn" : $item->name}}</span>
                    <span class="count">({{isset($order_group[$item->id]) ? $order_group[$item->id] : 0}})</span>
                    <span class="live-stream"></span>
                    <span style="clear:both;"></span>
                </a>
            @endforeach
        @endif
    </div>

    <table class="table table-custom table-striped">
        <thead>
        <tr>
            <th class="text-center" style="width: 30px;"><input type="checkbox" id="checkAll"></th>
            <th class="text-center nowrap">Sale</th>
            <th class="text-center">Mã đơn <br> Ngày chốt đơn</th>
            <th class="text-center">Kho <br> PTGH <br> Mã giao vận</th>
            <th class="text-center">Care đơn <br> Ghi chú kế toán</th>
            <th class="text-center">Trạng thái giao hàng</th>
            <th class="text-center">ĐSNB</th>
            <th class="text-center" style="min-width: 200px">Sản phẩm</th>
            <th class="text-center">SL</th>
            <th class="text-center">Đơn giá</th>
            <th class="text-center">Thành tiền</th>
            <th class="text-center">CK</th>
            <th class="text-center">Phí dịch vụ VC</th>
            <th class="text-center">Phí VC hỗ trợ khách</th>
            <th class="text-center">Phí VC thu của khách</th>
            <th class="text-center">Khách đặt cọc</th>
            <th class="text-center">Tổng tiền</th>
            <th class="text-center">Họ tên <br> Số điện thoại</th>
            <th class="text-center">Địa chỉ <br> Ghi chú giao hàng</th>

        </tr>
        </thead>
        <tbody>
        @if(count($orders))
            @foreach($orders as $key => $item)
                @if($item)
                    {{--{{dd($item->order_text)}}--}}
                    <tr>
                        <td class="text-center"><input type="checkbox" class="getData" value="{{$item->id}}" data-code="{{$item->code}}"> <span>{{$key+1}}</span></td>
                        <td class="text-center">{{@$item->sale->name}}</td>
                        <td class="text-center">
                            <span style="color:var(--main-color); font-weight: bold;">{{$item->code}}</span>
                            <div class="small-tip">
                                {{ $item->ngay_chot_don ? date("d / m / Y H:i", strtotime($item->ngay_chot_don)) : date("d / m / Y H:i", strtotime($item->updated_at))}}
                            </div>
                        </td>
                        <td class="text-center">{{@$item->depot->name}} <br> Thủ công</td>
                        <td class="text-center"></td>
                        <td class="text-center">{{$item->status == 1 ? 'Chờ vận đơn' : @$item->orderStatus->name}}</td>
                        <td class="text-center"></td>
                        <td class="text-center">{!! $item->order_text['product_text'] !!}</td>
                        <td class="text-center">{!! $item->order_text['product_quantity'] !!}</td>
                        <td class="text-center">{!! $item->order_text['product_price'] !!}</td>
                        <td class="text-center">{{@number_format($item->total)}}</td>
                        <td class="text-center">{{@number_format($item->advan_price)}}</td>
                        <td class="text-center"></td>
                        <td class="text-center"></td>
                        <td class="text-center"></td>
                        <td class="text-center"></td>
                        <td class="text-center">{{@number_format($item->total)}}</td>
                        <td class="text-center">{{@$item->customer->name}} <br> {{@$item->customer->phone}}</td>
                        <td class="text-center">{{$item->address}}</td>
                    </tr>
                    {{--                {{$sum[$item->id]++}}--}}

                @endif
            @endforeach
        @endif
        </tbody>
    </table>
    <div class="mt-2 float-right">
        <select id="customPage" style="height: 33px !important;">
            <option value="20" {{isset($paginate) && $paginate == 20 ? 'selected' : ''}}>20</option>
            <option value="50" {{isset($paginate) && $paginate == 50 ? 'selected' : ''}}>50</option>
            <option value="100" {{isset($paginate) && $paginate == 100 ? 'selected' : ''}}>100</option>
        </select>
        @if($orders->currentPage() == $orders->lastPage())
            <span>({{$orders->total()}}/{{$orders->total()}})</span>
        @else
            <span>({{$orders->currentPage()*$orders->perPage()}}/ {{$orders->total()}})</span>
        @endif
        {{$orders->links()}}
    </div>
</div>

<script src="{{asset('backend/js/fixed_scrollbar_bottom.js')}}"></script>
