<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHistoryOperationDepotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('history_operation_depots', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('status')->index();
            $table->boolean('hoa_hong')->default(0);
            $table->string('type_ship')->comment('tài khoản vận chuyển')->nullable();
            $table->text('note')->nullable();
            $table->integer('customer_id');
            $table->integer('warehouse_id')->comment('người phụ trách');
            $table->integer('user_id');
            $table->boolean('type')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('history_operation_depots');
    }
}
