<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExportImportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('export_imports', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->boolean('type')->comment('0: import, 1:export')->default(0);
            $table->text('detail')->comment('chi tiết tải')->nullable();
            $table->integer('data')->comment('1:product, 2:customer, 3:depot, 4:ke toan ...');
            $table->integer('user_id');
            $table->string('ip_address');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('export_imports');
    }
}
