<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateJobSchedulesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('job_schedules', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('customer_id');
            $table->dateTime('time_operation')->comment('thời gian tác nghiệp');
            $table->integer('user_id')->comment('người nhận tác nghiệp');
            $table->text('title')->comment('ghi chú')->nullable();
            $table->boolean('status')->comment('trạng thái, =1 đã gửi, = 2 đã xem')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('job_schedules');
    }
}
