<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHistoryChangeStatusesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('history_change_statuses', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('status_old')->comment('trạng thái trước')->index();
            $table->integer('status_new')->comment('trạng thái sau')->index();
            $table->text('note')->comment('ghi chú')->nullable();
            $table->integer('customer_id')->comment('id khách hàng')->index();
            $table->integer('user_id')->nullable('người chuyển trạng thái')->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('history_change_statuses');
    }
}
