<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderDetailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_detail', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('order_id')->index()->default(0)->comment('ID đơn hàng');
            $table->integer('product_id')->index()->default(0)->comment('ID sản phẩm');
            $table->integer('price')->default(0)->comment('Đơn giá sản phẩm');
            $table->integer('quantity')->default(0)->comment('Số lượng');
            $table->integer('total_price')->default(0)->comment('Tổng tiền');
//            $table->integer('sale_id')->index()->default(0)->comment('Sale');
//            $table->integer('mkt_id')->index()->default(0)->comment('marketing');
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_detail');
    }
}
