<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('customer_id')->index()->comment('ma KH');
            $table->integer('sale_id')->index()->default(0)->comment('Sale');
            $table->integer('mkt_id')->index()->default(0)->comment('marketing');
            $table->integer('total')->default(0)->comment('Tổng giá trị đơn');
            $table->integer('discount')->default(0)->comment('Chiết khấu');
            $table->integer('ship_price')->default(0)->comment('Phí vận chuyển');
            $table->integer('advance_price')->default(0)->comment('Tiền KH tạm ứng');
            $table->integer('status')->default(0)->comment('Trạng thái đơn');
            $table->text('receive')->nullable()->comment('Người nhận hàng hộ');

            $table->longText('description')->nullable()->comment('Ghi chú');
            $table->longText('messages')->nullable()->comment('Tin nhắn trao đổi');

            $table->longText('address')->nullable()->comment('Địa chỉ chi tiết');
            $table->string('ward_id')->default(0)->comment('Xã phường');
            $table->string('district_id')->default(0)->comment('Huyện');
            $table->string('city_id')->default(0)->comment('Thành phố');

            $table->integer('depot_id')->default(0)->comment('Id kho');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
