<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTimeAutosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('time_autos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->default('1 giờ');
            $table->integer('time')->default(1);
            $table->integer('time_text')->comment('1:phút,2:giờ,3;ngày')->default(2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('time_autos');
    }
}
