<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerStatusesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_statuses', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->comment('')->nullable();
            $table->integer('position')->comment('số thứ tự')->default(0);
            $table->boolean('start')->comment('trạng thái bắt đầu')->default(0);
            $table->boolean('is_depot_number_float')->comment('kho số thả nổi')->default(0);
            $table->boolean('change_time')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_statuses');
    }
}
