<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTeamsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('teams', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->comment('tên nhóm');
            $table->integer('department_id')->comment('phòng ban')->index();
            $table->string('code')->comment('mã nhóm');
            $table->integer('leader_id')->comment('trưởng nhóm')->index();
            $table->integer('cskh_id')->comment('Nhóm chăm sóc khách hàng tương ứng')->nullable()->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('teams');
    }
}
