<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('source_id')->comment('nguồn data')->default(0);
            $table->string('name',256);
            $table->string('phone');
            $table->text('message')->comment('nội dung tin nhắn');
            $table->string('user_id')->comment('sale nhận data')->nullable();
            $table->integer('status')->comment('trạng thái khách hàng')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers');
    }
}