<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFanpagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fanpages', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->text('access_token')->comment('Token page');
            $table->integer('user_id')->default(0)->index()->comment('User nhân viên add fanpage');
            $table->string('page_id')->index();
            $table->string('name');
            $table->text('avatar')->nullable();
            $table->string('role_text')->nullable();
            $table->integer('used')->comment('chấp nhận sử dụng');
            $table->integer('source_id')->default(0)->comment('Id nguồn');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fanpages');
    }
}
