<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDepotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('depots', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('code')->nullable();
            $table->string('city')->comment('tỉnh/tp');
            $table->string('district')->comment('quận/huyện');
            $table->string('wards')->comment('phường/xã');
            $table->string('phone');
            $table->string('address');
            $table->string('note')->nullable();
            $table->string('transport_default')->comment('Tỉnh/TP mặc định giao từ kho này')->nullable();
            $table->integer('position')->default(0);
            $table->integer('user_id')->comment('quản kho')->default(0);
            $table->string('user_phone')->comment('sdt quản kho')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('depots');
    }
}
