<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('email')->unique();
            $table->string('phone')->unique();
            $table->string('password');
            $table->integer('role_id')->comment('Quyền người dùng');
            $table->tinyInteger('status')->comment('0: Hoạt động,1: Đã khóa')->default(0);
            $table->timestamp('birthday')->nullable()->comment('Sinh nhật');
            $table->tinyInteger('gender')->nullable()->comment('0: Nam, 1: Nữ')->default(0);
            $table->string('avatar')->nullable()->comment('Ảnh đại diện');
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
