<?php

namespace App;

use App\Models\Team;
use App\Models\TeamMember;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Helpers\Functions;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Authenticatable
{
    use Notifiable;
    use SoftDeletes;

    protected $guarded = ['id'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public static function search($search)
    {
        $search['searchStatus'] = isset($search['searchStatus']) ? $search['searchStatus'] : '';
        $docs = self::when(isset($search['searchDepartment']), function ($q) use ($search) {
            return $q->where('department_id', $search['searchDepartment']);
        })->when($search['searchStatus'], function ($q) use ($search) {
            return $q->where('status', $search['searchStatus']);
        })->when(isset($search['department_id']) && $search['department_id'], function ($q) use ($search) {
            return $q->where('department_id', $search['department_id']);
        })->when(isset($search['is_leader']) && $search['is_leader'], function ($q) use ($search) {
            return $q->where('is_leader', $search['is_leader']);
        })->when(isset($search['name']) && $search['name'], function ($q) use ($search) {
            return $q->where('name', 'like', '%' . $search['name'] . '%');
        })->when(isset($search['team_member']) && $search['team_member'], function ($q) use ($search) {
            return $q->whereIn('id', $search['team_member']);
        })->when(isset($search['user_active']) && $search['user_active'], function ($q) use ($search) {
            return $q->where('status', $search['user_active']);
        })->when(isset($search['pc_name']) && $search['pc_name'], function ($q) use ($search) {
            if($search['pc_name'] == 2){ //đăng nhập nhiều nơi
                $q->where('pc_name', 0);
            } else {
                $q->where('pc_name','<>', 0);
            }
        })->when(isset($input['start_date']) && isset($input['end_date']), function ($q) use ($search) {
            $q->whereBetween('created_at', [
                Functions::yearMonthDayTime($search['start_date']),
                Functions::yearMonthDayTime($search['end_date']),
            ]);
        })->orderBy('id', 'desc');
        return $docs;
    }

    public function teamMember(){
        return $this->hasOne(TeamMember::class);
    }

    public function teams(){
        return $this->hasMany(Team::class,'leader_id');
    }

    public function team_members(){
        return $this->hasOne(TeamMember::class,'user_id');
    }
}
