<?php
/**
 * Created by PhpStorm.
 * User: Ominext
 * Date: 2019-06-25
 * Time: 10:59 AM
 */

namespace App\Services;

use App\User;

class UserService
{
    public $user;

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    public function getAll($search = null)
    {
        $data = $this->user->search($search);
        return $data;
    }

    public function find($id)
    {
        $model = $this->user->find($id);

        return $model;
    }

    public function findWhere($column, $value)
    {
        $model = $this->user->where($column, $value)->get();

        return $model;
    }

    public function create(array $data)
    {
        if (empty($data)) return false;
        $model = $this->user->create($data);

        $users = User::where('department_id',$model->department_id)->withTrashed()->get();

        $input['username'] = $model->username . (count($users));
        $model->update($input);
        return $model;
    }

    public function update($id, array $data)
    {
        if (empty($data)) return false;
        if (empty($data['password'])) {
            unset($data['password']);
        } else {
            $data['password'] = bcrypt($data['password']);
        };
        $model = $this->find($id);
        $model->update($data);

        return $model;
    }

}
