<?php
/**
 * Created by PhpStorm.
 * User: Ominext
 * Date: 2019-06-25
 * Time: 10:59 AM
 */

namespace App\Services;

use App\Models\Product;

class ProductService
{
    public $product;

    public function __construct(Product $product)
    {
        $this->product = $product;
    }

    public function create(array $data)
    {
        if (empty($data)) return false;
        $model = $this->product->create($data);
        return $model;
    }

    public function update($id, array $data)
    {
        if (empty($data)) return false;
        $model = $this->find($id);
        $model->update($data);
        return $model;
    }

    public function find($id)
    {
        $model = $this->product->find($id);

        return $model;
    }

    public function delete($id)
    {
        $model = $this->find($id);

        return $model->delete();

    }

    public function findCode($code)
    {
        $model = $this->product->where('code', $code)->first();

        return $model;
    }
}
