<?php

namespace App\Services\Marketing;

use App\Models\Customer;
use App\Models\Source;

class SourceService
{
    public $source,$customer;

    public function __construct(Source $source,Customer $customer)
    {
        $this->source = $source;
        $this->customer = $customer;
    }


    public function index($search = null){
        $data = $this->source->search($search);
        $data = $data->with('userCreate')->get()->map(function ($item) {
            $item['all_product'] = $item->getProductTextAttribute();
            $item['all_sale'] = $item->getUsername();
            $item['sales'] = $item->sales();
            $item['products'] = $item->products();
            $item['userCreate'] = $item->getUser();
            return $item;
        });
        return $data;
    }

    public function update($data,$id){
        $this->source->find($id)->update($data);
        return 1;
    }

    public function delete($id){
        $customer = $this->customer->where('source_id',$id)->first();
        if ($customer){
            return false;
        }
        return $this->source->find($id)->delete();
    }

}
