<?php

namespace App\Services;

use App\Constants\StatusCode;
use App\Models\Customer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CustomerService
{
    private $customer;

    public function __construct(Customer $customer)
    {
        $this->customer = $customer;
    }

    public function index($request)
    {
        $type = isset($request['type_date']) && $request['type_date'] ? $request['type_date'] : 'created_at';
        $data = $this->customer->search($request,$type)->with('orders', 'fanpage');
        return $data;
    }

    public function create(array $data)
    {
        if (empty($data)) return false;
        $model = $this->customer->create($data);
        return $model;
    }

    public function show($id)
    {

    }

    public function update($data, $id)
    {
        $fanpage = Fanpage::find($id);
        $fanpage->used = $data['used'];
        $fanpage->source_id = $data['source_id'];
        $fanpage->save();
        return $fanpage;
    }

    public function delete($id)
    {

    }
}
