<?php

namespace App\Models;

use App\Constants\OrderConstant;
use App\Constants\SourceConstant;
use App\Helpers\Functions;
use App\User;
use Illuminate\Database\Eloquent\Model;

class Source extends Model
{
    protected $guarded = [];

    public static function search($search)
    {
        $docs = self::when(isset($search['start_date']) && isset($search['end_date']), function ($query) use ($search) {
            $query->whereBetween('updated_at', [
                Functions::yearMonthDayTime($search['start_date']),
                Functions::yearMonthDayTime($search['end_date']),
            ]);
        })->when(isset($search['searchName']) && $search['searchName'], function ($query) use ($search) {
            return $query->where('name', 'like', '%' . $search['searchName'] . '%');
        })->when(isset($search['searchType']) && $search['searchType'], function ($query) use ($search) {
            if ($search['searchType'] == SourceConstant::TYPE_CONNECT_WEBSITE) {
                return $query->whereIn('type', [SourceConstant::TYPE_CONNECT_WEBSITE]);
            } else {
                return $query->where('type', $search['searchType']);
            }
        })->when(isset($search['searchArrayUser']) && $search['searchArrayUser'], function ($query) use ($search) {
            return $query->whereIn('user_id', $search['searchArrayUser']);
        })->when(isset($search['searchUser']) && $search['searchUser'], function ($query) use ($search) {
            return $query->where('user_id', $search['searchUser']);
        })->when(isset($search['searchId']) && $search['searchId'], function ($query) use ($search) {
            return $query->where('id', $search['searchId']);
        })->when(isset($search['searchChanel']) && $search['searchChanel'], function ($query) use ($search) {
            return $query->where('chanel', $search['searchChanel']);
        })->when(isset($search['searchAccept']) && $search['searchAccept'], function ($query) use ($search) {
            if($search['searchAccept'] == 1){
                return $query->where('accept', $search['searchAccept']);
            } else {
                return $query->where('accept', 0);
            }
        })->when(isset($search['searchProduct']) && $search['searchProduct'], function ($query) use ($search) {
            return $query->where('product_id', 'like', '%"' . $search['searchProduct'] . '"%');
        })->when(isset($search['searchId']) && $search['searchId'], function ($query) use ($search) {
            return $query->where('id', $search['searchId']);
        })->orderBy('updated_at', 'desc');
        return $docs;
    }

    public function getProductTextAttribute()
    {
        $products = Product::whereIn('id', json_decode($this->product_id))->pluck('name')->toArray();
        return implode(', ', $products);
    }

    public function getUsername()
    {
        $users = User::whereIn('id', json_decode($this->sale_id))->pluck('name')->toArray();
        return implode(', ', $users);
    }

    public function getProductTextAttribute1()
    {
        $products = Product::whereIn('id', json_decode($this->product_id))->pluck('name')->toArray();
        return implode(',</br> ', $products);
    }

    public function sales()
    {
        return $users = User::whereIn('id', json_decode($this->sale_id))->get();
    }

    public function products()
    {
        return $products = Product::whereIn('id', json_decode($this->product_id))->get();
    }

    public function userCreate()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function getUser()
    {
        return $data = User::find($this->user_id);
    }

    public function customers()
    {
        return $this->hasMany(Customer::class, 'source_id', 'id');
    }

    public function priceMarketings()
    {
        return $this->hasMany(PriceMarketing::class, 'source_id', 'id');
    }

    public function getCustomDataAttribute()
    {
        $source_id = $this->id;
        $data['customers'] = Customer::where('source_id', $source_id)->count();

        $customers = Customer::where('source_id', $source_id)->pluck('id')->toArray();
        $orders = Order::whereIn('customer_id', $customers)->where('status', '>', 0)->where('status', '<>', OrderConstant::STATUS_HUY_DON);

        $doanh_so = $orders->sum('total');
        $discount = $orders->sum('discount');
        $data['doanh_so'] = $doanh_so;
        $data['discount'] = $discount;

        $orders1 = clone $orders;
        $arr_order_id = $orders1->pluck('id')->toArray();
        $order_details = OrderDetail::whereIn('order_id', $arr_order_id)->count();

        $data['count_products'] = $order_details;
        $data['orders'] = $orders->count();
        return $data;
    }


}
