<?php

namespace App\Models;

use App\Helpers\Functions;
use App\User;
use Illuminate\Database\Eloquent\Model;

class PriceMarketing extends Model
{
    protected $guarded = [];

    public static function search($input)
    {
        $docs = self::when(isset($input['start_date']) && isset($input['end_date']), function ($q) use ($input) {
            $q->whereBetween('date', [
                Functions::yearMonthDayTime($input['start_date']),
                Functions::yearMonthDayTime($input['end_date']),
            ]);
        })->when(isset($input['source_id']) && $input['source_id'], function ($q) use ($input) {
            $q->where('source_id', $input['source_id']);
        })->when(isset($input['user_id']) && $input['user_id'], function ($q) use ($input) {
            $q->where('user_id', $input['user_id']);
        });
        return $docs;
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function source()
    {
        return $this->belongsTo(Source::class);
    }

    public function getProductName()
    {
        $arr_product_id = $this->source->product_id;
        $users = Product::whereIn('id', json_decode($arr_product_id))->pluck('name')->toArray();
        return implode(', ', $users);
    }
}
