<?php

namespace App\Models;

use App\Helpers\Functions;
use Illuminate\Database\Eloquent\Model;

class OrderDetail extends Model
{
    protected $guarded = [];
    protected $table = 'order_detail';

    public function product(){
        return $this->belongsTo(Product::class,'product_id');
    }

    public static function search($input, $orderBy = "id")
    {
        $docs = self::when(isset($input['start_date']) && isset($input['end_date']), function ($q) use ($input) {
            $q->whereBetween('created_at', [
                Functions::yearMonthDayTime($input['start_date']),
                Functions::yearMonthDayTime($input['end_date']),
            ]);
        })->when(isset($input['product_id']), function ($q) use ($input) {
            $q->where('product_id', $input['product_id']);
        })->orderByDesc($orderBy);
        return $docs;
    }
}
