<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HistoryOperationDepot extends Model
{
    //
    protected $guarded = [];

    public function customer(){
        return $this->belongsTo(Customer::class);
    }

    public function orderStatus(){
        return $this->belongsTo(OrderStatus::class,'status','id');
    }

    public function user(){
        return $this->belongsTo(\App\User::class);
    }

    public function warehouse(){
        return $this->belongsTo(\App\User::class,'warehouse_id');
    }

    public function order(){
        return $this->belongsTo(Order::class,'order_id');
    }

}
