<?php

namespace App\Models;

use App\Helpers\Functions;
use App\User;
use Illuminate\Database\Eloquent\Model;

class HistoryChangeStatus extends Model
{
    //
    protected $guarded = [];

    public function status_old()
    {
        return $this->belongsTo(CustomerStatus::class, 'status_old');
    }

    public function status_new()
    {
        return $this->belongsTo(CustomerStatus::class, 'status_new');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public static function search($input)
    {
        $data = self::when(isset($input['sale_id']), function ($q) use ($input) {
            $q->where('user_id', $input['sale_id']);
        })->when(isset($input['type']) && isset($input['type']), function ($q) use ($input) {
            $q->where('type', $input['type']);
        })->when(isset($input['start_date']) && isset($input['end_date']), function ($q) use ($input) {
            $q->whereBetween('updated_at', [
                Functions::yearMonthDayTime($input['start_date']),
                Functions::yearMonthDayTime($input['end_date']),
            ]);
        });
        return $data;
    }
}
