<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $regexEmail = "/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/";
        $user_id = $this->request->get('user_id');

        if ($user_id) {
            return [
                'full_name' => 'required',
                'email'     => 'required|email|unique:users,email,' .
                    $this->segment(3)
                    . ',id|regex:/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/',
                'phone'     => 'required|digits_between:10,12|unique:users,phone,' . $this->segment(3) . ',id',
                'department_id'   => 'required',
            ];
        } else {
            return [
                'email'     => 'email|unique:users,email|regex:' . $regexEmail,
                'phone'     => 'required|digits_between:10,12|unique:users',
            ];
        }
    }

    public function messages()
    {
        return [
            'full_name.required'   => __('user.name_required'),
            'department_id.required'     => 'Quyền là bắt buộc',
//            'email.required'       => __('user.email_required'),
            'email.email'          => __('user.invalid_email'),
            'email.regex'          => __('user.invalid_email'),
            'email.unique'         => __('user.uinque_image'),
            'phone.required'       => __('user.phone_required'),
            'phone.unique'         => __('user.phone_unique'),
            'phone.digits_between' => __('user.invalid_phone'),
//            'password.required'    => __('user.password_required'),
//            'password.confirmed'   => __('user.password_confirmed'),
        ];
    }
}
