<?php

namespace App\Http\Controllers;

use App\Models\Depot;
use App\Services\UserService;
use App\User;
use Illuminate\Http\Request;
use Socialite;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function __construct(UserService $user)
    {
//        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $depot = Depot::all();
        $pagi = User::paginate(1);
        return view('dashbroad', compact('pagi', 'depot'));
    }


    public function postLoginFB(Request $request)
    {
//        return Socialite::driver('facebook')->scopes(['pages_messaging,pages_read_engagement'])->redirect();
        return Socialite::driver('facebook')->scopes(['public_profile', 'email', 'pages_messaging','pages_read_engagement', 'pages_manage_metadata', 'pages_show_list'])->redirect();
    }

    public function callbackFB(Request $request)
    {
        $user = Socialite::driver('facebook')->user();
        session(['login-facebook' => $user]);
        return redirect(route('marketing.fanpage.index'));
    }

    public function removeAccount(Request $request)
    {
        $request->session()->forget('login-facebook');
        return redirect(route('marketing.fanpage.index'));
    }

    /**
     * Check duplicate user
     *
     * @param Request $request
     * @return int
     */
    public function checkUniqueUser(Request $request)
    {
        if (isset($request->email) && $request->email) {
            $user = User::where('email', $request->email)->withTrashed()->first();
        } elseif (isset($request->phone) && $request->phone) {
            $user = User::where('phone', $request->phone)->withTrashed()->first();
        }
        return isset($user) && $user ? 'true' : 'false';
    }
}
