<?php


namespace App\Http\Controllers\Backend;

use App\Constants\CustomerConstant;
use App\Constants\DepartmentConstant;
use App\Helpers\Functions;
use App\Models\UserFilerGrid;
use App\Services\UserService;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{

    public $user;

    public function __construct(UserService $user)
    {
        $this->user = $user;
    }

    public function getAllSale()
    {
        $search['searchDepartment'] = DepartmentConstant::SALE;
        $user = $this->user->getAll($search)->get();
        return response()->json([
            'user' => $user
        ]);
    }

    public function ajaxGetUser()
    {
        $user = Auth::user();
        return response()->json([
            'user' => $user
        ]);
    }

    public function clientData(Request $request)
    {

        return response()->json([
            'data' => 123
        ]);
    }

    public function profile()
    {
        $user = Auth::user();
        return view('backend.pages.profile.index', compact('user'));
    }

    public function updateProfile(Request $request)
    {

        $user = Auth::user();

        $dirUploadImage = CustomerConstant::UPLOAD_FOLDER_USER;

        $required['confirm_password'] = 'required_with:password|same:password';


        if ($request->input('email') && $request->input('email') != $user->email) {
//            $request->validate([
//                'email' => 'email|unique:users'
//            ]);
            $required['email'] = 'email|unique:users';
        }


        if ($request->input('phone') && $request->input('phone') != $user->phone) {
//            $request->validate([
//                'phone' => 'unique:users', 'regex:/(0)[0-9]{9}/',
//            ]);
            $required['phone'] = 'unique:users|regex:/(0)[0-9]{9}/';
        }

        $messages = [
            'name.required' => 'Tên không được bỏ trống !',
            'confirm_password.same' => 'Mật khẩu không trùng nhau',
            'phone.regex' => 'SDT không hợp lệ'
        ];

        $validator = Validator::make($request->all(), $required, $messages);
        if ($validator->fails()) {
            return back()->withErrors($validator);
        }

        $data = $request->except('_method', '_token');
        if ($request->hasFile('avatar')) {
            if ($user->avatar) {
                Functions::unlinkUpload($user->avatar);
            }
            $file = $request->avatar;
            $image_name = time() . '-' . $file->getClientOriginalName();
            $data['avatar'] = $dirUploadImage . $image_name;
            $file->move(public_path($dirUploadImage), $image_name);
        }

        $data =  Arr::except($data, ['confirm_password']);

        if ($request->password == null) {
            $data = Arr::except($data, ['password']);
        } else {
            $data['password'] = bcrypt($request->password);
        }

        $user->update($data);
        return redirect()->back();
    }

    /**
     * Lưu setting filter in table
     * @param Request $request
     * @return int
     */
    public function userFilterGrid(Request $request)
    {
        $user = Auth::user();
        $data = $request->all();
        $data['user_id'] = $user->id;
        $user_filter = UserFilerGrid::where('user_id', $user->id)->where('url', $request->url)->first();
        if ($user_filter) {
            $user_filter->update($data);
        } else {
            UserFilerGrid::create($data);
        }

        return 1;
    }
}
